package cn.net.wanmo.module.sys.entity;

import cn.net.wanmo.base.entity.MyBaseTreeEntity;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.module.sys.util.DictUtil;
import cn.net.wanmo.module.sys.util.SysDictType;

/**
 * 菜单 Entity，<br>
 * 实现 Comparable 接口，默认按照 sort排序
 */
public class Menu extends MyBaseTreeEntity<Menu> {
	private static final long serialVersionUID = 1L;
	public static final String ROOT_ID = "1";

	private String parentId; // 父级编号
	private String parentIds; // 所有父级编号
	private Integer sort; // sort
	private String href; // 链接
	private String icon; // 图标
	private Dict isShow; // 是否在菜单中显示
	private String permission; // 权限标识
	private Integer hierarchy; // 层级

	public Menu() {
		super();
	}

	public Menu(String id) {
		super(id);
	}

	public Menu(Menu parent) {
		super();
		this.parent = parent;
	}

	public String getParentId() {
		return parentId;
	}

	public void setParentId(String parentId) {
		this.parentId = parentId;
	}

	public String getParentIds() {
		return parentIds;
	}

	public void setParentIds(String parentIds) {
		this.parentIds = parentIds;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

	public String getHref() {
		return href;
	}

	public void setHref(String href) {
		this.href = href;
	}

	public String getIcon() {
		return icon;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	public Dict getIsShow() {
		isShow = DictUtil.fitProperty(isShow, SysDictType.YES_OR_NO);
		return isShow;
	}

	public void setIsShow(Dict isShow) {
		this.isShow = isShow;
	}

	public String getPermission() {
		return permission;
	}

	public void setPermission(String permission) {
		this.permission = permission;
	}

	public Integer getHierarchy() {
		return hierarchy;
	}

	public void setHierarchy(Integer hierarchy) {
		this.hierarchy = hierarchy;
	}

	@Override
	public String getDefaultOrderBy() {
		return " a.sort ";
	}

	@Override
	public int compareTo(Menu o) {
		if (o == null || o.getSort() == null || this.sort == null) {
			return 0;
		}
		return this.sort.compareTo(o.getSort());
	}

	@Override
	public String getRootId() {
		return ROOT_ID;
	}

	// Mapper 支持开始
	private String isShowValue;

	public void setIsShowValue(String isShowValue) {
		this.isShowValue = isShowValue;
		setIsShow(new Dict(null, isShowValue));
	}
    // Mapper 支持结束
}
