package cn.net.wanmo.module.sys.service;

import java.util.List;

import cn.net.wanmo.base.service.BaseExtendLayUIService;
import cn.net.wanmo.module.sys.entity.Role;
import cn.net.wanmo.module.sys.entity.User;

/**
 * 系统用户 Service
 */
public interface UserService extends BaseExtendLayUIService<User> {

	/**
	 * 根据登录名查找用户
	 *
	 * @param loginName 登录名
	 * @return
	 */
	User getByLoginName(String loginName);

	/**
	 * 删除用户与角色关系
	 *
	 * @param userId 用户主键
	 * @return
	 */
	int deleteUserRole(String userId);

	/**
	 * 插入用户与角色关系
	 *
	 * @param userId   用户主键
	 * @param roleList 角色集合
	 * @return
	 */
	int insertUserRole(String userId, List<Role> roleList);

}
