package cn.net.wanmo.module.sys.service.impl;

import java.util.List;

import cn.net.wanmo.base.service.impl.BaseExtendLayUIServiceImpl;
import org.springframework.stereotype.Service;

import cn.net.wanmo.module.sys.dao.AnnexDao;
import cn.net.wanmo.module.sys.entity.Annex;
import cn.net.wanmo.module.sys.service.AnnexService;

@Service
public class AnnexServiceImpl extends BaseExtendLayUIServiceImpl<Annex, AnnexDao> implements AnnexService {

	@Override
	public List<Annex> findListByRelationId(String relationId) {
		Annex annex = new Annex();
		annex.setRelationId(relationId);
		return findList(annex);
	}

	@Override
	public List<Annex> findListRelationIdAndFileType(String relationId, String fileType) {
		Annex annex = new Annex();
		annex.setRelationId(relationId);
		annex.setFileType(fileType);
		return findList(annex);
	}

}
