package cn.net.wanmo.module.sys.service.impl;

import java.util.List;

import cn.net.wanmo.base.service.impl.BaseTreeExtendServiceImpl;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;

import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.module.sys.dao.MenuDao;
import cn.net.wanmo.module.sys.entity.Menu;
import cn.net.wanmo.module.sys.service.MenuService;
import cn.net.wanmo.module.sys.util.MenuUtil;

@Service
public class MenuServiceImpl extends BaseTreeExtendServiceImpl<Menu, MenuDao> implements MenuService {

	@Override
	public List<Menu> findListByRoleId(String roleId) {
		if (StringUtil.isBlank(roleId)) {
			return Lists.newArrayList();
		}

		return dao.findListByRoleId(roleId);
	}

	@Override
	public void clearCache() {
		MenuUtil.clearCache();
	}
}
