package cn.net.wanmo.module.sys.util;

import java.util.ArrayList;
import java.util.List;

import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.plugin.spring.util.SpringUtil;
import cn.net.wanmo.module.sys.entity.Area;
import cn.net.wanmo.module.sys.service.AreaService;
import cn.net.wanmo.util.EhCacheUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 区域工具类
 */
public class AreaUtil {
	private static final Logger logger = LoggerFactory.getLogger(AreaUtil.class);
	// TODO 需要处理
	private static AreaService areaService = SpringUtil.getBean(AreaService.class);
	public static final String CACHE_NAME = "areaCache";
	public static final String CACHE_KEY = "cacheSysAreaAll";

	/**
	 * 获取子节点
	 *
	 * @param parentId
	 * @return
	 */
	public static List<Area> findListByParentId(String parentId) {
		List<Area> list = new ArrayList<Area>();

		for (Area area : findListAll()) {
			if (StringUtil.equals(parentId, area.getParentId())) {
				list.add(area);
			}
		}

		return list;
	}

	/**
	 * 查找所有字典信息
	 *
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static List<Area> findListAll() {
		List<Area> listArea = null;
		Object object = EhCacheUtils.get(CACHE_NAME, CACHE_KEY);
		if (object == null) {
			listArea = areaService.findList(new Area().getDefaultOrderBy());
			EhCacheUtils.put(CACHE_NAME, CACHE_KEY, listArea);
		} else {
			listArea = (List<Area>) object;
		}

		return listArea;
	}

	/**
	 * 移除所有区域信息
	 *
	 * @return
	 */
	public static void remove() {
	}
}
