package cn.net.wanmo.module.sys.util;

import java.util.ArrayList;
import java.util.List;

import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.plugin.spring.util.SpringUtil;
import cn.net.wanmo.module.sys.entity.Dept;
import cn.net.wanmo.module.sys.service.DeptService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 部门工具类
 */
public class DeptUtil {
	private static final Logger logger = LoggerFactory.getLogger(DeptUtil.class);
	private static DeptService deptService = SpringUtil.getBean(DeptService.class);

	/**
	 * 获取的部门子节点
	 *
	 * @param parentId
	 * @return
	 */
	public static List<Dept> findListByParentId(String parentId) {
		List<Dept> list = new ArrayList<Dept>();

		for (Dept dept : findListAll()) {
			if (StringUtil.equals(parentId, dept.getParentId())) {
				list.add(dept);
			}
		}

		return list;
	}

	/**
	 * 查找所有部门信息
	 *
	 * @return
	 */
	public static List<Dept> findListAll() {
		return deptService.findList(new Dept().getDefaultOrderBy());
	}

	/**
	 * 移除所有部门信息
	 *
	 * @return
	 */
	public static void remove() {
	}

}
