package cn.net.wanmo.timertask;

import cn.net.wanmo.module.sys.util.AnnexUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

/**
 * TimerTask 定时任务工具类
 */
public class TimerTaskAnnex {

	/** 管理所有启用的定时任务 */
	private static List<Timer> listTimer = new ArrayList<Timer>();

	/**
	 * 启动定时任务
	 */
	public static void startTask() {
		startClearRubbishAnnexTask();
	}

	/**
	 * 垃圾附件清理任务<br>
	 * 30 秒钟后执行， 每隔6个小时更新一次
	 */
	public static void startClearRubbishAnnexTask() {
		Timer timer = new Timer("clear_rubbish_annex_task");
		timer.schedule(new TimerTask() {
			@Override
			public void run() {
				AnnexUtil.clearRubbishAnnex();
			}
		}, 30 * 1000, 1000 * 60 * 60 * 6);

		listTimer.add(timer);
	}

	/**
	 * 取消定时任务
	 */
	public static void closeTask() {
		try {
			if (listTimer == null || listTimer.isEmpty()) {
				return;
			}

			for (Timer timer : listTimer) {
				timer.toString();
				timer.cancel();
				timer.purge();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
