/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.base.entity;

import cn.net.wanmo.base.entity.BaseEntity;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.module.sys.entity.User;
import cn.net.wanmo.module.sys.util.UserUtil;
import cn.net.wanmo.security.Principal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public abstract class MyBaseEntity<Entity>
extends BaseEntity<Entity> {
    private static final long serialVersionUID = -4504153476364215436L;
    protected User createUser;
    protected User updateUser;

    public MyBaseEntity() {
    }

    public MyBaseEntity(String id) {
        super(id);
    }

    @JsonIgnore
    public User getCreateUser() {
        String createUserId = this.getCreateUserId();
        if (StringUtil.isBlank((CharSequence)createUserId)) {
            return this.createUser;
        }
        return new User(createUserId);
    }

    public void setCreateUser(User createUser) {
        this.createUser = createUser;
    }

    @JsonIgnore
    public User getUpdateUser() {
        String updateUserId = this.getUpdateUserId();
        if (StringUtil.isBlank((CharSequence)updateUserId)) {
            return this.updateUser;
        }
        return new User(updateUserId);
    }

    public void setUpdateUser(User updateUser) {
        this.updateUser = updateUser;
    }

    public void preInsert() {
        super.preInsert();
        this.setCreateUser(new User(this.getCurrentUserId()));
        this.setUpdateUser(new User(this.getCurrentUserId()));
    }

    public void preUpdate() {
        super.preUpdate();
        this.setUpdateUser(new User(this.getCurrentUserId()));
    }

    public String getCurrentUserId() {
        Principal principal = UserUtil.getPrincipal();
        if (principal == null) {
            return null;
        }
        return principal.getId();
    }

    public void setCreateUserId(String createUserId) {
        super.setCreateUserId(createUserId);
        this.setCreateUser(new User(createUserId));
    }

    public void setUpdateUserId(String updateUserId) {
        super.setUpdateUserId(updateUserId);
        this.setUpdateUser(new User(updateUserId));
    }
}

