/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.module.sys.service.impl;

import cn.net.wanmo.base.entity.BaseEntity;
import cn.net.wanmo.base.service.impl.BaseExtendLayUIServiceImpl;
import cn.net.wanmo.common.util.CollectionUtil;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.module.sys.dao.RoleDao;
import cn.net.wanmo.module.sys.entity.Menu;
import cn.net.wanmo.module.sys.entity.Role;
import cn.net.wanmo.module.sys.service.RoleService;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleServiceImpl
extends BaseExtendLayUIServiceImpl<Role, RoleDao>
implements RoleService {
    @Override
    public List<Role> findListByUserId(String userId) {
        return ((RoleDao)this.dao).findListByUserId(userId);
    }

    @Override
    @Transactional(readOnly=false)
    public int deleteRoleMenu(String roleId) {
        if (StringUtil.isBlank((CharSequence)roleId)) {
            return 0;
        }
        return ((RoleDao)this.dao).deleteRoleMenu(roleId);
    }

    @Override
    @Transactional(readOnly=false)
    public int insertRoleMenu(String roleId, List<Menu> menuList) {
        if (StringUtil.isBlank((CharSequence)roleId) || CollectionUtil.isEmpty(menuList)) {
            return 0;
        }
        return ((RoleDao)this.dao).insertRoleMenu(roleId, menuList);
    }

    public int save(Role entity) {
        int num = super.save((BaseEntity)entity);
        this.deleteRoleMenu(entity.getId());
        this.insertRoleMenu(entity.getId(), entity.getMenus());
        return num;
    }

    public int delete(String id) {
        this.deleteRoleMenu(id);
        return super.delete(id);
    }
}

