/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.module.sys.service.impl;

import cn.net.wanmo.base.entity.BaseEntity;
import cn.net.wanmo.base.service.impl.BaseExtendLayUIServiceImpl;
import cn.net.wanmo.common.util.CollectionUtil;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.module.sys.dao.UserDao;
import cn.net.wanmo.module.sys.entity.Role;
import cn.net.wanmo.module.sys.entity.User;
import cn.net.wanmo.module.sys.service.UserService;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
extends BaseExtendLayUIServiceImpl<User, UserDao>
implements UserService {
    @Override
    public User getByLoginName(String loginName) {
        return ((UserDao)this.dao).getByLoginName(loginName);
    }

    @Override
    @Transactional(readOnly=false)
    public int deleteUserRole(String userId) {
        if (StringUtil.isBlank((CharSequence)userId)) {
            return 0;
        }
        return ((UserDao)this.dao).deleteUserRole(userId);
    }

    @Override
    @Transactional(readOnly=false)
    public int insertUserRole(String userId, List<Role> roleList) {
        if (StringUtil.isBlank((CharSequence)userId) || CollectionUtil.isEmpty(roleList)) {
            return 0;
        }
        return ((UserDao)this.dao).insertUserRole(userId, roleList);
    }

    public int save(User entity) {
        int num = super.save((BaseEntity)entity);
        this.deleteUserRole(entity.getId());
        this.insertUserRole(entity.getId(), entity.getRoles());
        return num;
    }

    public int delete(String id) {
        this.deleteUserRole(id);
        return super.delete(id);
    }
}

