/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.module.sys.util;

import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.util.DateUtil;
import cn.net.wanmo.common.util.FileUtil;
import cn.net.wanmo.common.util.IdGen;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.module.sys.entity.Annex;
import cn.net.wanmo.module.sys.service.AnnexService;
import cn.net.wanmo.module.sys.util.UserUtil;
import cn.net.wanmo.plugin.spring.util.SpringUtil;
import cn.net.wanmo.util.PropUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class AnnexUtil {
    private static final Logger logger = LoggerFactory.getLogger(AnnexUtil.class);
    private static AnnexService annexService = (AnnexService)SpringUtil.getBean(AnnexService.class);

    public static Annex toAnnex(MultipartFile file) {
        Annex annex = new Annex();
        annex.setIsNewRecord(true);
        annex.setId(IdGen.uuid());
        annex.setOriginalFilename(file.getOriginalFilename());
        annex.setContentType(file.getContentType());
        annex.setFileSize(file.getSize());
        annex.setFileName(FileUtil.getFileNameNoSuffix((String)annex.getOriginalFilename()));
        annex.setFileType("0");
        annex.setDeleteStatus(Annex.STATUS_REMOVE);
        String userId = UserUtil.getPrincipal() == null ? "noid" : UserUtil.getPrincipal().getId();
        String relativePath = userId + "/" + DateUtil.formatDay() + "/";
        annex.setFilePath(relativePath + annex.getPhysicalName());
        return annex;
    }

    public static void transferFile(MultipartFile file, Annex annex) throws IOException {
        File targetFile = new File(AnnexUtil.getUploadBaseDir() + annex.getFilePath());
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        file.transferTo(targetFile);
    }

    public static void clearRubbishAnnex() {
        Annex entity = new Annex();
        entity.setDeleteStatus(Annex.STATUS_REMOVE);
        List list = annexService.findList(entity);
        for (Annex annex : list) {
            Date updateTime = annex.getUpdateTime();
            if (DateUtil.nowLong() - updateTime.getTime() <= 1800000L) continue;
            try {
                FileUtil.forceDeleteOnExit((File)new File(annex.getFilePath()));
                annexService.delete(annex.getId());
            }
            catch (IOException iOException) {}
        }
    }

    public static String getUploadBaseDir() {
        String basePath = PropUtil.getAnnexUploadBasedir();
        if (StringUtil.isBlank((CharSequence)basePath)) {
            basePath = SpringUtil.getRequest().getServletContext().getRealPath("/");
        }
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        basePath = basePath + "upload/";
        return basePath;
    }

    public static String getDownFileName(HttpServletRequest request, String filename) throws UnsupportedEncodingException {
        String agent = request.getHeader("User-Agent");
        String filenameEncoder = "";
        if (agent.contains("MSIE")) {
            filenameEncoder = URLEncoder.encode(filename, "utf-8");
            filenameEncoder = filenameEncoder.replace("+", " ");
        } else {
            filenameEncoder = agent.contains("Firefox") ? "=?utf-8?B?" + CodecUtil.encodeBase64((byte[])filename.getBytes("utf-8")) + "?=" : URLEncoder.encode(filename, "utf-8");
        }
        return filenameEncoder;
    }
}

