/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.module.sys.util;

import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.module.sys.entity.Dict;
import cn.net.wanmo.module.sys.service.DictService;
import cn.net.wanmo.plugin.spring.util.SpringUtil;
import cn.net.wanmo.util.EhCacheUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictUtil {
    private static final Logger logger = LoggerFactory.getLogger(DictUtil.class);
    private static DictService dictService = (DictService)SpringUtil.getBean(DictService.class);
    public static final String CACHE_NAME = "dictCache";
    public static final String CACHE_KEY = "cacheSysDictAll";

    public static Dict getDict(String type, String value) {
        return DictUtil.getDict(type, value, true);
    }

    public static Dict getDict(String type, String value, boolean isCache) {
        Dict dict = new Dict("", value, type);
        List<Dict> listByType = null;
        listByType = isCache ? DictUtil.findListByType(type) : dictService.findListByType(type);
        for (Dict e : listByType) {
            if (!StringUtil.equals((CharSequence)value, (CharSequence)e.getValue())) continue;
            dict = e;
            break;
        }
        return dict;
    }

    public static List<Dict> findListByType(String type) {
        ArrayList<Dict> list = new ArrayList<Dict>();
        for (Dict e : DictUtil.findListAll()) {
            if (!StringUtil.equals((CharSequence)type, (CharSequence)e.getType())) continue;
            list.add(e);
        }
        return list;
    }

    public static List<Dict> findListAll() {
        List listDict = null;
        Object object = EhCacheUtils.get(CACHE_NAME, CACHE_KEY);
        if (object == null) {
            listDict = dictService.findList();
            EhCacheUtils.put(CACHE_NAME, CACHE_KEY, listDict);
        } else {
            listDict = (List)object;
        }
        return listDict;
    }

    public static Dict fitProperty(Dict property, String dictType) {
        if (property == null || StringUtil.isBlank((CharSequence)property.getValue())) {
            property = new Dict();
            property.setType(dictType);
        } else {
            Dict temp = DictUtil.getDict(dictType, property.getValue());
            property.setLabel(temp.getLabel());
            property.setType(dictType);
        }
        return property;
    }
}

