/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.module.sys.util;

import cn.net.wanmo.common.util.BooleanUtil;
import cn.net.wanmo.common.util.CollectionUtil;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.module.sys.entity.Menu;
import cn.net.wanmo.module.sys.entity.Role;
import cn.net.wanmo.module.sys.entity.User;
import cn.net.wanmo.module.sys.service.MenuService;
import cn.net.wanmo.module.sys.util.RoleUtil;
import cn.net.wanmo.module.sys.util.UserUtil;
import cn.net.wanmo.plugin.spring.util.SpringUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuUtil {
    private static final Logger logger = LoggerFactory.getLogger(MenuUtil.class);
    private static MenuService menuService = (MenuService)SpringUtil.getBean(MenuService.class);

    public static List<Menu> findListAll() {
        return menuService.findList(new Menu().getDefaultOrderBy());
    }

    public static List<Menu> findListByParentId(String parentId) {
        ArrayList<Menu> list = new ArrayList<Menu>();
        for (Menu menu : MenuUtil.findListAll()) {
            if (!StringUtil.equals((CharSequence)parentId, (CharSequence)menu.getParentId())) continue;
            list.add(menu);
        }
        return list;
    }

    public static List<Menu> findListByUser(String userId) {
        return MenuUtil.findListByUser(new User(userId));
    }

    public static List<Menu> findListByUser(User user) {
        List<Object> returnList = Lists.newArrayList();
        if (user == null || StringUtil.isBlank((CharSequence)user.getId())) {
            return returnList;
        }
        if (StringUtil.equals((CharSequence)"1", (CharSequence)user.getId())) {
            returnList = MenuUtil.findListAll();
        } else {
            List<Role> listRole = RoleUtil.findListByUser(user);
            if (CollectionUtil.isNotEmpty(listRole)) {
                for (Role r : listRole) {
                    List<Menu> listMenu = menuService.findListByRoleId(r.getId());
                    for (Menu m : listMenu) {
                        if (MenuUtil.isContainMenu((List<Menu>)returnList, m).booleanValue()) continue;
                        returnList.add((Object)m);
                    }
                }
            }
        }
        Collections.sort(returnList);
        return returnList;
    }

    public static Boolean isContainMenu(List<Menu> menuList, Menu menu) {
        boolean flag = false;
        if (CollectionUtil.isEmpty(menuList) || menu == null) {
            flag = false;
        } else {
            for (Menu e : menuList) {
                if (!StringUtil.equals((CharSequence)e.getId(), (CharSequence)menu.getId())) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static void clearCache() {
    }

    public static List<Menu> hasPermissionMenus(List<Menu> menuList) {
        ArrayList<Menu> returnList = new ArrayList<Menu>();
        Subject subject = UserUtil.getSubject();
        for (Menu menu : menuList) {
            if (StringUtil.isBlank((CharSequence)menu.getPermission())) continue;
            boolean isShow = BooleanUtil.toBoolean((String)menu.getIsShow().getValue());
            boolean permitted = subject.isPermitted(menu.getPermission());
            if (!isShow || !permitted) continue;
            returnList.add(menu);
        }
        return returnList;
    }
}

