/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.module.sys.util;

import cn.net.wanmo.common.util.BooleanUtil;
import cn.net.wanmo.common.util.CollectionUtil;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.module.sys.entity.Role;
import cn.net.wanmo.module.sys.entity.User;
import cn.net.wanmo.module.sys.service.RoleService;
import cn.net.wanmo.plugin.spring.util.SpringUtil;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleUtil {
    private static final Logger logger = LoggerFactory.getLogger(RoleUtil.class);
    private static RoleService roleService = (RoleService)SpringUtil.getBean(RoleService.class);

    public static List<Role> findListByUser(String userId) {
        return RoleUtil.findListByUser(new User(userId));
    }

    public static List<Role> findListByUser(User user) {
        List<Object> returnList = Lists.newArrayList();
        if (user == null || StringUtil.isBlank((CharSequence)user.getId())) {
            return returnList;
        }
        returnList = StringUtil.equals((CharSequence)"1", (CharSequence)user.getId()) ? roleService.findList() : roleService.findListByUserId(user.getId());
        if (CollectionUtil.isNotEmpty((List)returnList)) {
            Iterator<Object> it = returnList.iterator();
            while (it.hasNext()) {
                Role role = (Role)((Object)it.next());
                if (BooleanUtil.toBoolean((String)role.getUseable().getValue())) continue;
                it.remove();
            }
        }
        return returnList;
    }

    public static Boolean isContainRole(List<Role> roleList, Role role) {
        boolean flag = false;
        if (CollectionUtil.isEmpty(roleList) || role == null) {
            flag = false;
        } else {
            for (Role e : roleList) {
                if (!StringUtil.equals((CharSequence)e.getId(), (CharSequence)role.getId())) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }
}

