/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.module.sys.util;

import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.module.sys.entity.User;
import cn.net.wanmo.module.sys.service.UserService;
import cn.net.wanmo.plugin.spring.util.SpringUtil;
import cn.net.wanmo.security.Principal;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUtil {
    private static final Logger logger = LoggerFactory.getLogger(UserUtil.class);
    private static UserService userService = (UserService)SpringUtil.getBean(UserService.class);

    public static User getUser(String id) {
        if (StringUtil.isBlank((CharSequence)id)) {
            return null;
        }
        return (User)userService.get(id);
    }

    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static Principal getPrincipal() {
        Principal principal = null;
        try {
            Subject subject = UserUtil.getSubject();
            principal = (Principal)subject.getPrincipal();
        }
        catch (Exception e) {
            principal = null;
        }
        return principal;
    }

    public static Session getSession() {
        Session session = null;
        try {
            Subject subject = UserUtil.getSubject();
            session = subject.getSession();
        }
        catch (InvalidSessionException e) {
            session = null;
        }
        return session;
    }

    public static User getLoginUser() {
        Principal principal = UserUtil.getPrincipal();
        if (principal == null) {
            return null;
        }
        return UserUtil.getUser(principal.getId());
    }
}

