/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.security.filter;

import cn.net.wanmo.common.crypto.rsa.RsaUtil;
import cn.net.wanmo.common.util.Exceptions;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.security.token.UsernamePasswordToken;
import cn.net.wanmo.util.PropUtil;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormAuthenticationFilter
extends org.apache.shiro.web.filter.authc.FormAuthenticationFilter {
    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String DEFAULT_CAPTCHA_PARAM = "validateCode";
    public static final String DEFAULT_MESSAGE_PARAM = "message";

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        String username = this.getUsername(request);
        String password = this.getPassword(request);
        password = RsaUtil.decryptByPri((String)password, (String)PropUtil.priKeyBase64);
        String host = this.getHost(request);
        boolean rememberMe = this.isRememberMe(request);
        return new UsernamePasswordToken(username, password, rememberMe, host, null);
    }

    protected String getUsername(ServletRequest request) {
        String username = super.getUsername(request);
        if (StringUtil.isBlank((CharSequence)username)) {
            username = StringUtil.toString((Object)request.getAttribute(this.getUsernameParam()), (String)"");
        }
        return username;
    }

    protected String getPassword(ServletRequest request) {
        String password = super.getPassword(request);
        if (StringUtil.isBlank((CharSequence)password)) {
            password = StringUtil.toString((Object)request.getAttribute(this.getPasswordParam()), (String)"");
        }
        return password;
    }

    protected boolean isRememberMe(ServletRequest request) {
        String isRememberMe = WebUtils.getCleanParam((ServletRequest)request, (String)this.getRememberMeParam());
        if (StringUtil.isBlank((CharSequence)isRememberMe)) {
            isRememberMe = StringUtil.toString((Object)request.getAttribute(this.getRememberMeParam()), (String)"");
        }
        return Boolean.parseBoolean(isRememberMe);
    }

    protected String getCaptcha(ServletRequest request) {
        return WebUtils.getCleanParam((ServletRequest)request, (String)this.getCaptchaParam());
    }

    public String getUsernameParam() {
        return "loginName";
    }

    public String getPasswordParam() {
        return "loginPswd";
    }

    public String getCaptchaParam() {
        return DEFAULT_CAPTCHA_PARAM;
    }

    public String getMessageParam() {
        return DEFAULT_MESSAGE_PARAM;
    }

    public String getSuccessUrl() {
        return super.getSuccessUrl();
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        WebUtils.getAndClearSavedRequest((ServletRequest)request);
        return super.onLoginSuccess(token, subject, request, response);
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        String message = "";
        if (e instanceof IncorrectCredentialsException) {
            message = "\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5.";
        } else if (e instanceof UnknownAccountException) {
            message = "\u8d26\u53f7\u4e0d\u5b58\u5728.";
        } else if (e instanceof DisabledAccountException) {
            message = "\u7981\u7528\u7684\u8d26\u53f7";
        } else if (e instanceof ExpiredCredentialsException) {
            message = "\u51ed\u8bc1\u8fc7\u671f";
        } else if (e instanceof ExcessiveAttemptsException) {
            message = "\u8ba4\u8bc1\u6b21\u6570\u8d85\u8fc7\u9650\u5236";
        } else if (e instanceof LockedAccountException) {
            message = "\u8d26\u53f7\u88ab\u9501\u5b9a";
        } else {
            message = "\u7cfb\u7edf\u51fa\u73b0\u70b9\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01";
            this.logger.error(Exceptions.getStackTraceAsString((Throwable)e));
        }
        request.setAttribute(this.getMessageParam(), (Object)message);
        return true;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        return super.onAccessDenied(request, response);
    }
}

