/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.security.realm;

import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.util.BooleanUtil;
import cn.net.wanmo.common.util.CollectionUtil;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.module.sys.entity.Menu;
import cn.net.wanmo.module.sys.entity.Role;
import cn.net.wanmo.module.sys.entity.User;
import cn.net.wanmo.module.sys.service.UserService;
import cn.net.wanmo.module.sys.util.MenuUtil;
import cn.net.wanmo.module.sys.util.RoleUtil;
import cn.net.wanmo.security.Principal;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.springframework.beans.factory.annotation.Autowired;

public class LoginNameRealm
extends AuthorizingRealm {
    @Autowired
    private UserService userService;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        Principal principal = (Principal)this.getAvailablePrincipal(principals);
        if (CollectionUtil.isNotEmpty(principal.getRoleList())) {
            for (Role r : principal.getRoleList()) {
                if (!StringUtil.isNotBlank((CharSequence)r.getEname())) continue;
                info.addRole(r.getEname());
            }
        }
        if (CollectionUtil.isNotEmpty(principal.getMenuList())) {
            for (Menu m : principal.getMenuList()) {
                if (!StringUtil.isNotBlank((CharSequence)m.getPermission())) continue;
                info.addStringPermission(m.getPermission());
            }
        }
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken authcToken = (UsernamePasswordToken)token;
        String loginName = authcToken.getUsername();
        User user = this.userService.getByLoginName(loginName);
        if (user == null) {
            throw new UnknownAccountException("\u7528\u6237 " + loginName + " \u4e0d\u5b58\u5728");
        }
        if (!BooleanUtil.toBoolean((String)user.getEnable().getValue())) {
            throw new DisabledAccountException("\u8be5\u8d26\u53f7\u5df2\u7981\u6b62\u4f7f\u7528");
        }
        Principal principal = new Principal(user);
        principal.setRoleList(RoleUtil.findListByUser(user));
        principal.setMenuList(MenuUtil.findListByUser(user));
        byte[] salt = CodecUtil.decodeHex((String)user.getLoginPswd().substring(0, 16));
        return new SimpleAuthenticationInfo((Object)principal, (Object)user.getLoginPswd().substring(16), ByteSource.Util.bytes((byte[])salt), this.getName());
    }

    protected void checkPermission(Permission permission, AuthorizationInfo info) {
        this.authorizationValidate(permission);
        super.checkPermission(permission, info);
    }

    protected boolean[] isPermitted(List<Permission> permissions, AuthorizationInfo info) {
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission permission : permissions) {
                this.authorizationValidate(permission);
            }
        }
        return super.isPermitted(permissions, info);
    }

    public boolean isPermitted(PrincipalCollection principals, Permission permission) {
        this.authorizationValidate(permission);
        return super.isPermitted(principals, permission);
    }

    protected boolean isPermittedAll(Collection<Permission> permissions, AuthorizationInfo info) {
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission permission : permissions) {
                this.authorizationValidate(permission);
            }
        }
        return super.isPermittedAll(permissions, info);
    }

    private void authorizationValidate(Permission permission) {
    }

    @PostConstruct
    public void initCredentialsMatcher() {
        HashedCredentialsMatcher matcher = new HashedCredentialsMatcher("SHA-1");
        matcher.setHashIterations(1024);
        this.setCredentialsMatcher((CredentialsMatcher)matcher);
    }

    protected void clearCache(PrincipalCollection principals) {
        super.clearCache(principals);
    }
}

