/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.security.session;

import cn.net.wanmo.common.util.DateUtil;
import cn.net.wanmo.common.util.ObjectUtil;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.security.session.SessionDAO;
import cn.net.wanmo.util.PropUtil;
import cn.net.wanmo.util.Servlets;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.EnterpriseCacheSessionDAO;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheSessionDAO
extends EnterpriseCacheSessionDAO
implements SessionDAO {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected Serializable doCreate(Session session) {
        String uri;
        HttpServletRequest request = Servlets.getRequest();
        if (ObjectUtil.isNotNull((Object)request) && Servlets.isStaticFile(uri = request.getServletPath())) {
            return null;
        }
        super.doCreate(session);
        this.logger.debug("createSession {} {}", (Object)session, (Object)(ObjectUtil.isNull((Object)request) ? "" : request.getRequestURI()));
        return session.getId();
    }

    protected void doUpdate(Session session) {
        if (session == null || session.getId() == null) {
            return;
        }
        HttpServletRequest request = Servlets.getRequest();
        if (ObjectUtil.isNotNull((Object)request)) {
            String uri = request.getServletPath();
            if (Servlets.isStaticFile(uri)) {
                return;
            }
            if (StringUtil.startsWith((CharSequence)uri, (CharSequence)PropUtil.getValue("web.view.prefix")) && StringUtil.endsWith((CharSequence)uri, (CharSequence)PropUtil.getValue("web.view.suffix"))) {
                return;
            }
        }
        super.doUpdate(session);
    }

    protected void doDelete(Session session) {
        if (session == null || session.getId() == null) {
            return;
        }
        super.doDelete(session);
        this.logger.debug("deleteSession {} ", (Object)session.getId());
    }

    protected Session doReadSession(Serializable sessionId) {
        return super.doReadSession(sessionId);
    }

    public Session readSession(Serializable sessionId) throws UnknownSessionException {
        try {
            Session s = null;
            HttpServletRequest request = Servlets.getRequest();
            if (ObjectUtil.isNotNull((Object)request)) {
                String uri = request.getServletPath();
                if (Servlets.isStaticFile(uri)) {
                    return null;
                }
                s = (Session)ObjectUtil.cast((Object)request.getAttribute("session_" + sessionId));
            }
            if (ObjectUtil.isNotNull(s)) {
                return s;
            }
            Session session = super.readSession(sessionId);
            if (ObjectUtil.isNotNull((Object)request) && ObjectUtil.isNotNull((Object)session)) {
                request.setAttribute("session_" + sessionId, (Object)session);
            }
            return session;
        }
        catch (UnknownSessionException e) {
            return null;
        }
    }

    @Override
    public Collection<Session> getActiveSessions(boolean includeLeave) {
        return this.getActiveSessions(includeLeave, null, null);
    }

    @Override
    public Collection<Session> getActiveSessions(boolean includeLeave, Object principal, Session filterSession) {
        if (includeLeave && principal == null) {
            return this.getActiveSessions();
        }
        HashSet sessions = Sets.newHashSet();
        for (Session session : this.getActiveSessions()) {
            boolean isActiveSession = false;
            if (includeLeave || DateUtil.pastMinutes((Date)session.getLastAccessTime()) <= 3L) {
                isActiveSession = true;
            }
            if (ObjectUtil.isNotNull((Object)principal)) {
                PrincipalCollection pc = (PrincipalCollection)ObjectUtil.cast((Object)session.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY));
                if (principal.toString().equals(ObjectUtil.isNull((Object)pc) ? "" : pc.getPrimaryPrincipal().toString())) {
                    isActiveSession = true;
                }
            }
            if (ObjectUtil.isNotNull((Object)filterSession) && filterSession.getId().equals(session.getId())) {
                isActiveSession = false;
            }
            if (!isActiveSession) continue;
            sessions.add(session);
        }
        return sessions;
    }
}

