package cn.net.wanmo.ehcache2;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.InputStream;
import java.net.URL;

public class CacheUtil {
    private static Logger logger = LoggerFactory.getLogger(CacheUtil.class);

    public static CacheManager cacheManager = null; // 缓存管理器
    static {
        cacheManager = getManager();
    }

    /**
     * 获取 CacheManager
     * @return CacheManager
     */
    private static CacheManager getManager() {
        return CacheManager.create();
    }

    /**
     * 获取 CacheManager
     * @return CacheManager
     */
    public static CacheManager getManager(Configuration configuration) {
        cacheManager = CacheManager.create(configuration);
        return cacheManager;
    }

    /**
     * 获取 CacheManager
     * @return CacheManager
     */
    public static CacheManager getManager(String configurationFileName) {
        cacheManager = CacheManager.create(configurationFileName);
        return cacheManager;
    }

    /**
     * 获取 CacheManager
     * @return CacheManager
     */
    public static CacheManager getManager(URL configurationFileURL) {
        cacheManager = CacheManager.create(configurationFileURL);
        return cacheManager;
    }


    /**
     * 获取 CacheManager
     * @return CacheManager
     */
    public static CacheManager getManager(InputStream inputStream) {
        cacheManager = CacheManager.create(inputStream);
        return cacheManager;
    }

    /**
     * 创建缓存对象
     * @param cacheName 缓存名称
     */
    public static void addCache(String cacheName) {
        cacheManager.addCache(cacheName);
    }

    /**
     * 创建缓存对象
     * @param cacheName 缓存名称
     * @return Ehcache
     */
    public static Ehcache addCacheIfAbsent(String cacheName) {
        return cacheManager.addCacheIfAbsent(cacheName);
    }

    /**
     * 获取缓存对象
     * @param cacheName 缓存名称
     * @return 缓存对象
     */
    public static Cache getCache(String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            cacheManager.addCache(cacheName);
            cache = cacheManager.getCache(cacheName);
        }
        return cache;
    }

    /**
     * 关闭缓存管理器
     */
    public static void shutdown() {
        if (cacheManager == null) {
            return;
        }

        cacheManager.shutdown();
    }

}
