/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.ehcache2;

import cn.net.wanmo.ehcache2.CacheUtil;
import java.io.Serializable;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.search.Query;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;

public class CacheObj<Key extends Serializable, Value extends Serializable> {
    private String cacheName;
    private Cache cache;

    public CacheObj(String cacheName) {
        this.cacheName = cacheName;
        Ehcache ehcache = CacheUtil.addCacheIfAbsent(cacheName);
        CacheConfiguration configuration = ehcache.getCacheConfiguration();
        configuration.memoryStoreEvictionPolicy(MemoryStoreEvictionPolicy.LRU);
        configuration.setMaxElementsInMemory(200);
        configuration.setOverflowToDisk(true);
        configuration.setDiskSpoolBufferSizeMB(100);
        configuration.setDiskExpiryThreadIntervalSeconds(21600L);
        configuration.setEternal(false);
        configuration.setTimeToIdleSeconds(21600L);
        configuration.setTimeToLiveSeconds(43200L);
        this.cache = CacheUtil.getCache(cacheName);
    }

    public Cache getCache() {
        return this.cache;
    }

    public void put(Key key, Value value) {
        Element element = new Element(key, value);
        this.cache.put(element);
    }

    public Element putIfAbsent(Key key, Value value) {
        Element element = new Element(key, value);
        return this.cache.putIfAbsent(element);
    }

    public Value get(Key key) {
        Element element = this.cache.get(key);
        Object value = element.getObjectValue();
        return (Value)((Serializable)this.cast(value));
    }

    public Integer getSize() {
        return this.cache == null ? null : Integer.valueOf(this.cache.getSize());
    }

    public Query createQuery() {
        return this.cache.createQuery();
    }

    public void evictExpiredElements() {
        this.cache.evictExpiredElements();
    }

    public boolean remove(Key key) {
        return this.cache.remove(key);
    }

    public void remove(Set<Key> set) {
        this.cache.removeAll(set);
    }

    public Element replace(Key key, Value value) {
        Element element = new Element(key, value);
        return this.cache.replace(element);
    }

    public boolean replace(Key key, Value valueOld, Value valueNew) {
        Element elementOld = new Element(key, valueOld);
        Element elementNew = new Element(key, valueNew);
        return this.cache.replace(elementOld, elementNew);
    }

    public boolean isKeyInCache(Key key) {
        return this.cache.isKeyInCache(key);
    }

    public boolean isValueInCache(Key key) {
        return this.cache.isValueInCache(key);
    }

    public String getName() {
        return this.cache.getName();
    }

    public void flush() {
        this.cache.flush();
    }

    public void dispose() {
        this.cache.dispose();
    }

    private <T> T cast(Object obj) {
        return (T)obj;
    }
}

