package cn.net.wanmo.ehcache3;

import org.ehcache.Cache;
import org.ehcache.config.CacheConfiguration;

import java.util.Iterator;
import java.util.Set;

/**
 * 缓存对象
 * @param <Key> 缓存 key 类型
 * @param <Value> 缓存 value 类型
 */
public class CacheObj<Key, Value> {
    private String cacheName;
    private Cache<Key, Value> cache;

    public CacheObj(String cacheName) {
        this.cacheName = cacheName;
    }

    public CacheObj(String cacheName, Class<Key> keyClass, Class<Value> valueClass) {
        this.cacheName = cacheName;
        this.cache = CacheUtil.createCache(cacheName, keyClass, valueClass);
    }

    public CacheObj(String cacheName, CacheConfiguration<Key, Value> cacheConfiguration) {
        this.cacheName = cacheName;
        this.cache = CacheUtil.createCache(cacheName, cacheConfiguration);
    }

    public Cache<Key, Value> createCache(CacheConfiguration<Key, Value> cacheConfiguration) {
        this.cache = CacheUtil.createCache(cacheName, cacheConfiguration);
        return cache;
    }

    public Cache<Key, Value> getCache() {
        return cache;
    }

    public void put(Key key, Value value) {
        cache.put(key, value);
    }

    public Value putIfAbsent(Key key, Value value) {
        return cache.putIfAbsent(key, value);
    }

    public Value get(Key key) {
        return cache.get(key);
    }

    public void remove(Key key) {
        cache.remove(key);
    }

    public boolean remove(Key key, Value value) {
        return cache.remove(key, value);
    }

    public void remove(Set<Key> set) {
        cache.removeAll(set);
    }

    public Value replace(Key key, Value value) {
        return cache.replace(key, value);
    }

    public boolean replace(Key key, Value value1, Value value2) {
        return cache.replace(key, value1, value2);
    }

    public Iterator<Cache.Entry<Key, Value>> iterator() {
        return cache.iterator();
    }

    public boolean containsKey(Key key) {
        return cache.containsKey(key);
    }

    public void clear() {
        cache.clear();
    }

}
