package cn.net.wanmo.ehcache3;

import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.URL;

public class CacheUtil {

    private static Logger logger = LoggerFactory.getLogger(CacheUtil.class);

    private static String preConfigured = "preConfigured"; // 预制的缓存对象名称
    private static Class<String> keyType = String.class; // 预制的 key 类型
    private static Class<String> valueType = String.class; // 预制的 value 类型

    public static CacheConfiguration configuration = null; // 预制的缓存对象配置
    public static CacheManager cacheManager = null; // 缓存管理器
    public static Cache<String, String> cacheDefault = null; // 预制的缓存对象
    static {
        configuration = CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType, ResourcePoolsBuilder.heap(100)).build();
        cacheManager = getManager();
        cacheDefault = cacheManager.getCache(preConfigured, keyType, valueType);
    }

    /**
     * 获取 CacheManager ，并设置默认缓存对象的 Cache 参数
     * @return CacheManager
     */
    public static CacheManager getManager() {
        return CacheManagerBuilder.newCacheManagerBuilder()
                .withCache(preConfigured, configuration)
                .build(true);
    }

    /**
     * 获取 CacheManager ，并设置默认缓存对象的 Cache 参数
     * @param xmlConfigPath ehcache.xml
     * @return CacheManager
     */
    public static CacheManager getManager(String xmlConfigPath) {
        final URL myUrl = CacheUtil.class.getClass().getResource(xmlConfigPath);
        XmlConfiguration xmlConfig = new XmlConfiguration(myUrl);

        cacheManager = CacheManagerBuilder.newCacheManager(xmlConfig);
        return cacheManager;
    }

    /**
     * 设置缓存值（默认缓存对象）
     */
    public static void put(String key, String value) {
        cacheDefault.put(key, value);
    }

    /**
     * 获取缓存值（默认缓存对象）
     */
    public static String get(String key) {
        return cacheDefault.get(key);
    }

    /**
     * 创建缓存对象
     * @param cacheName 缓存名称
     * @param cacheConfiguration 缓存配置
     * @return 缓存对象
     */
    public static <K, V> Cache<K, V> createCache(String cacheName, CacheConfiguration<K, V> cacheConfiguration) {
        return cacheManager.createCache(cacheName, cacheConfiguration);
    }

    /**
     * 创建缓存对象
     * @param cacheName 缓存名称
     * @param keyType key 类型
     * @param valueType value 类型
     * @return 缓存对象
     */
    public static <K, V> Cache<K, V> createCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        CacheConfiguration<K, V> configuration = CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType, ResourcePoolsBuilder.heap(100)).build();
        return createCache(cacheName, configuration);
    }

}
