/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.ehcache3;

import cn.net.wanmo.ehcache3.CacheUtil;
import java.util.Iterator;
import java.util.Set;
import org.ehcache.Cache;
import org.ehcache.config.CacheConfiguration;

public class CacheObj<Key, Value> {
    private String cacheName;
    private Cache<Key, Value> cache;

    public CacheObj(String cacheName) {
        this.cacheName = cacheName;
    }

    public CacheObj(String cacheName, Class<Key> keyClass, Class<Value> valueClass) {
        this.cacheName = cacheName;
        this.cache = CacheUtil.createCache(cacheName, keyClass, valueClass);
    }

    public CacheObj(String cacheName, CacheConfiguration<Key, Value> cacheConfiguration) {
        this.cacheName = cacheName;
        this.cache = CacheUtil.createCache(cacheName, cacheConfiguration);
    }

    public Cache<Key, Value> createCache(CacheConfiguration<Key, Value> cacheConfiguration) {
        this.cache = CacheUtil.createCache(this.cacheName, cacheConfiguration);
        return this.cache;
    }

    public Cache<Key, Value> getCache() {
        return this.cache;
    }

    public void put(Key key, Value value) {
        this.cache.put(key, value);
    }

    public Value putIfAbsent(Key key, Value value) {
        return (Value)this.cache.putIfAbsent(key, value);
    }

    public Value get(Key key) {
        return (Value)this.cache.get(key);
    }

    public void remove(Key key) {
        this.cache.remove(key);
    }

    public boolean remove(Key key, Value value) {
        return this.cache.remove(key, value);
    }

    public void remove(Set<Key> set) {
        this.cache.removeAll(set);
    }

    public Value replace(Key key, Value value) {
        return (Value)this.cache.replace(key, value);
    }

    public boolean replace(Key key, Value value1, Value value2) {
        return this.cache.replace(key, value1, value2);
    }

    public Iterator<Cache.Entry<Key, Value>> iterator() {
        return this.cache.iterator();
    }

    public boolean containsKey(Key key) {
        return this.cache.containsKey(key);
    }

    public void clear() {
        this.cache.clear();
    }
}

