/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.ehcache3;

import java.net.URL;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUtil {
    private static Logger logger = LoggerFactory.getLogger(CacheUtil.class);
    private static String preConfigured = "preConfigured";
    private static Class<String> keyType = String.class;
    private static Class<String> valueType = String.class;
    public static CacheConfiguration configuration = null;
    public static CacheManager cacheManager = null;
    public static Cache<String, String> cacheDefault = null;

    public static CacheManager getManager() {
        return CacheManagerBuilder.newCacheManagerBuilder().withCache(preConfigured, configuration).build(true);
    }

    public static CacheManager getManager(String xmlConfigPath) {
        URL myUrl = CacheUtil.class.getClass().getResource(xmlConfigPath);
        XmlConfiguration xmlConfig = new XmlConfiguration(myUrl);
        cacheManager = CacheManagerBuilder.newCacheManager((Configuration)xmlConfig);
        return cacheManager;
    }

    public static void put(String key, String value) {
        cacheDefault.put((Object)key, (Object)value);
    }

    public static String get(String key) {
        return (String)cacheDefault.get((Object)key);
    }

    public static <K, V> Cache<K, V> createCache(String cacheName, CacheConfiguration<K, V> cacheConfiguration) {
        return cacheManager.createCache(cacheName, cacheConfiguration);
    }

    public static <K, V> Cache<K, V> createCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        CacheConfiguration configuration = CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType, (Builder)ResourcePoolsBuilder.heap((long)100L)).build();
        return CacheUtil.createCache(cacheName, configuration);
    }

    static {
        configuration = CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType, (Builder)ResourcePoolsBuilder.heap((long)100L)).build();
        cacheManager = CacheUtil.getManager();
        cacheDefault = cacheManager.getCache(preConfigured, keyType, valueType);
    }
}

