/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.jwt;

import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.jwt.BuilderData;
import cn.net.wanmo.common.util.DateUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class JwtUtil {
    public static String SIGNING = "WANMO-JWT";
    public static Integer EXPIRATION_TIME = 180;

    public static String createTokenBySigning(BuilderData data) {
        return JwtUtil.createTokenBySigning(data, SIGNING);
    }

    public static String createTokenBySigning(BuilderData data, String signing) {
        String token = Jwts.builder().setId(data.getId()).setHeaderParams(data.getHeader()).setIssuer(data.getIssuer()).setIssuedAt(data.getIssuedAt()).setSubject(data.getSubject()).setAudience(data.getAudience()).setNotBefore(data.getNotBefore()).setPayload(data.getPayload()).setExpiration(DateUtil.addSeconds((int)(data.getExpirationTime() == null ? EXPIRATION_TIME : data.getExpirationTime()))).addClaims(data.getClaims()).signWith(SignatureAlgorithm.HS512, signing).compact();
        return token;
    }

    public static String createTokenByKey(BuilderData data) {
        return JwtUtil.createTokenByKey(data, JwtUtil.generalKey());
    }

    public static String createTokenByKey(BuilderData data, Key key) {
        String token = Jwts.builder().setId(data.getId()).setHeader(data.getHeader()).setIssuer(data.getIssuer()).setIssuedAt(data.getIssuedAt()).setSubject(data.getSubject()).setAudience(data.getAudience()).setNotBefore(data.getNotBefore()).setExpiration(DateUtil.addSeconds((int)(data.getExpirationTime() == null ? EXPIRATION_TIME : data.getExpirationTime()))).setPayload(data.getPayload()).addClaims(data.getClaims()).signWith(SignatureAlgorithm.HS512, key).compact();
        return token;
    }

    public static Claims parseTokenBySigning(String token) {
        return JwtUtil.parseTokenBySigning(token, SIGNING);
    }

    public static Claims parseTokenBySigning(String token, String signing) {
        return (Claims)Jwts.parser().setSigningKey(signing).parseClaimsJws(token).getBody();
    }

    public static Claims parseTokenByKey(String token) {
        return JwtUtil.parseTokenByKey(token, JwtUtil.generalKey());
    }

    public static Claims parseTokenByKey(String token, Key key) {
        return (Claims)Jwts.parser().setSigningKey(key).parseClaimsJws(token).getBody();
    }

    public static SecretKey generalKey() {
        byte[] encodedKey = CodecUtil.encodeBase64((String)SIGNING).getBytes();
        SecretKeySpec key = new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
        return key;
    }
}

