package cn.net.wanmo.common.crypto.gm;

import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.util.Exceptions;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

import java.security.MessageDigest;

/**
 * SM3工具类(杂凑算法-hash算法)
 */
public class Sm3Util {
    /**
     * SM3计算hashCode
     * @param data   待计算数据
     * @return 签名值 16进制编码
     */
    public static String digest(String data) {
        SM3Digest sm3Digest = new SM3Digest();

        final byte[] dataBytes = data.getBytes();
        sm3Digest.update(dataBytes, 0, dataBytes.length);

        byte[] encrypt = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(encrypt, 0);

        return CodecUtil.encodeHex(encrypt);
    }

    /**
     * 通过密钥进行加密
     * @param data   被加密的数据
     * @param key       密钥
     * @return 签名值 16进制编码
     */
    public static String digest(String data, String key) {
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac(digest);

        KeyParameter keyParameter = new KeyParameter(key.getBytes());
        mac.init(keyParameter);

        final byte[] dataBytes = data.getBytes();
        mac.update(dataBytes, 0, dataBytes.length);

        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);

        return CodecUtil.encodeHex(result);
    }

    /**
     * SM3计算hashCode
     * @param data   待计算数据
     * @return 签名值 16进制编码
     */
    public static String digest_0(String data) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SM3", Sm2Util.provider);

            final byte[] dataBytes = data.getBytes();
            byte[] result = messageDigest.digest(dataBytes);

            return CodecUtil.encodeHex(result);
        } catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }
}
