package cn.net.wanmo.common.security;

import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.crypto.AesUtil;
import cn.net.wanmo.common.util.Exceptions;
import cn.net.wanmo.common.util.StringUtil;

/**
 * 密码 加密解密工具类
 */
public class PasswordUtil {

    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_INTERATIONS = 1024;
    public static final int SALT_SIZE = 8;

    /**
     * 生成安全的密码，生成随机的16位salt并经过1024次 sha-1 hash
     */
    public static String entryptPassword(String plainPassword) {
        String plain = CodecUtil.unescapeHtml(plainPassword);
        byte[] salt = Digests.generateSalt(SALT_SIZE);
        String hashPassword = Digests.sha1Hex(plain.getBytes(), salt, HASH_INTERATIONS);
        return CodecUtil.encodeHex(salt) + hashPassword;
    }

    /**
     * 验证密码
     *
     * @param plainPassword 明文密码
     * @param password      密文密码
     * @return 验证成功返回true
     */
    public static boolean validatePassword(String plainPassword, String password) {
        String plain = CodecUtil.unescapeHtml(plainPassword);
        byte[] salt = CodecUtil.decodeHex(password.substring(0, 16));
        String hashPassword = Digests.sha1Hex(plain.getBytes(), salt, HASH_INTERATIONS);
        return password.equals(CodecUtil.encodeHex(salt) + hashPassword);
    }

    /**
     * 密码加密
     */
    public static String enPwd(String pwd) {
        String s;
        try {
            String keyStr = AesUtil.getRandomKey();
            String encryptStr = AesUtil.encrypt(pwd, keyStr);

            return CodecUtil.decodeBase64String(keyStr) + encryptStr;
        } catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    /**
     * 密码解密
     */
    public static String dePwd(String pwd) {
        String s;
        try {
            if (StringUtil.isBlank(pwd)) {
                return StringUtil.EMPTY;
            }

            String keyStr = pwd.substring(0, 16);
            String encryptStr = pwd.substring(16);

            String decryptStr = AesUtil.decrypt(encryptStr, CodecUtil.encodeBase64(keyStr));

            return decryptStr;
        } catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

}
