/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.crypto;

import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.util.Exceptions;
import cn.net.wanmo.common.util.StringUtil;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesUtil {
    static Logger logger = LoggerFactory.getLogger(AesUtil.class);
    private static final String KEY_ALGORITHM_AES = "AES";
    private static final String CIPHER_ALGORITHM_ECB = "AES/ECB/PKCS5Padding";
    private static final String CIPHER_ALGORITHM_CBC = "AES/CBC/PKCS5Padding";

    public static String encrypt(String data, String keyStr) {
        return AesUtil.encrypt(data, keyStr, false);
    }

    public static String encrypt(String data, String keyStr, boolean isDecodeBase64) {
        byte[] bytesData = StringUtil.getBytes((String)data);
        byte[] bytesKey = null;
        bytesKey = isDecodeBase64 ? CodecUtil.decodeBase64((String)keyStr) : StringUtil.getBytes((String)keyStr);
        return AesUtil.encrypt(bytesData, bytesKey);
    }

    public static String encrypt(byte[] data, byte[] keyStr) {
        return AesUtil.encrypt(data, keyStr, null);
    }

    public static String encrypt(String data, String keyStr, String ivStr) {
        return AesUtil.encrypt(data, keyStr, ivStr, false);
    }

    public static String encrypt(String data, String keyStr, String ivStr, boolean isDecodeBase64) {
        byte[] bytesData = StringUtil.getBytes((String)data);
        byte[] bytesKey = null;
        byte[] bytesIv = null;
        if (isDecodeBase64) {
            bytesKey = CodecUtil.decodeBase64((String)keyStr);
            bytesIv = CodecUtil.decodeBase64((String)ivStr);
        } else {
            bytesKey = StringUtil.getBytes((String)keyStr);
            bytesIv = StringUtil.getBytes((String)ivStr);
        }
        return AesUtil.encrypt(bytesData, bytesKey, bytesIv);
    }

    public static String encrypt(byte[] data, byte[] keyStr, byte[] ivStr) {
        try {
            Cipher cipher = AesUtil.getCipher(1, keyStr, ivStr);
            byte[] encryptBytes = cipher.doFinal(data);
            return CodecUtil.encodeBase64((byte[])encryptBytes);
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static String decrypt(String data, String keyStr) {
        return AesUtil.decrypt(data, keyStr, false);
    }

    public static String decrypt(String data, String keyStr, boolean isDecodeBase64) {
        byte[] dataBytes = CodecUtil.decodeBase64((String)data);
        byte[] keyBytes = null;
        keyBytes = isDecodeBase64 ? CodecUtil.decodeBase64((String)keyStr) : StringUtil.getBytes((String)keyStr);
        return AesUtil.decrypt(dataBytes, keyBytes);
    }

    public static String decrypt(byte[] data, byte[] keyStr) {
        return AesUtil.decrypt(data, keyStr, null);
    }

    public static String decrypt(String data, String keyStr, String ivStr) {
        return AesUtil.decrypt(data, keyStr, ivStr, false);
    }

    public static String decrypt(String data, String keyStr, String ivStr, boolean isDecodeBase64) {
        byte[] dataBytes = CodecUtil.decodeBase64((String)data);
        byte[] keyBytes = null;
        byte[] ivBytes = null;
        if (isDecodeBase64) {
            keyBytes = CodecUtil.decodeBase64((String)keyStr);
            ivBytes = CodecUtil.decodeBase64((String)ivStr);
        } else {
            keyBytes = StringUtil.getBytes((String)keyStr);
            ivBytes = StringUtil.getBytes((String)ivStr);
        }
        return AesUtil.decrypt(dataBytes, keyBytes, ivBytes);
    }

    public static String decrypt(byte[] data, byte[] keyStr, byte[] ivStr) {
        try {
            Cipher cipher = AesUtil.getCipher(2, keyStr, ivStr);
            byte[] decryptBytes = cipher.doFinal(data);
            return StringUtil.toString((byte[])decryptBytes);
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    private static Cipher getCipher(int mode, String key, String iv, boolean isDecodeBase64) {
        byte[] keyBytes = null;
        byte[] ivBytes = null;
        if (isDecodeBase64) {
            keyBytes = CodecUtil.decodeBase64((String)key);
            ivBytes = CodecUtil.decodeBase64((String)iv);
        } else {
            keyBytes = StringUtil.getBytes((String)key);
            ivBytes = StringUtil.getBytes((String)iv);
        }
        return AesUtil.getCipher(mode, keyBytes, ivBytes);
    }

    private static Cipher getCipher(int mode, byte[] key, byte[] iv) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, KEY_ALGORITHM_AES);
            Cipher cipher = null;
            if (iv == null) {
                cipher = Cipher.getInstance(CIPHER_ALGORITHM_ECB);
                cipher.init(mode, secretKeySpec);
            } else {
                cipher = Cipher.getInstance(CIPHER_ALGORITHM_CBC);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
                cipher.init(mode, (Key)secretKeySpec, ivParameterSpec);
            }
            return cipher;
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static String keyGenerate() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM_AES);
            keyGenerator.init(new SecureRandom());
            SecretKey secretKey = keyGenerator.generateKey();
            byte[] keyBytes = secretKey.getEncoded();
            return CodecUtil.encodeBase64((byte[])keyBytes);
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static String generateKey() {
        return AesUtil.keyGenerate();
    }

    public static String generateIv() {
        return AesUtil.keyGenerate();
    }

    public static String getRandomKey() {
        String randomCode = StringUtil.getRandomCode((int)16);
        return CodecUtil.encodeBase64((String)randomCode);
    }

    public static String getRandomIv() {
        String randomCode = StringUtil.getRandomCode((int)16);
        return CodecUtil.encodeBase64((String)randomCode);
    }
}

