/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.crypto.gm;

import cn.net.wanmo.common.charset.CharsetUtil;
import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.crypto.pojo.KeyPairBase64;
import cn.net.wanmo.common.crypto.pojo.KeyPairFiles;
import cn.net.wanmo.common.util.Exceptions;
import cn.net.wanmo.common.util.FileUtil;
import cn.net.wanmo.common.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;

public class Sm2Util {
    public static final String KEY_ALGORITHM = "EC";
    public static final Provider provider = new BouncyCastleProvider();
    public static final String SM3_WITH_SM2 = "SM3withSm2";

    public static KeyPair getKeyPair() {
        try {
            SecureRandom secureRandom = new SecureRandom();
            ECGenParameterSpec sm2Spec = new ECGenParameterSpec("sm2p256v1");
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(KEY_ALGORITHM, provider);
            kpg.initialize(sm2Spec);
            kpg.initialize(sm2Spec, secureRandom);
            KeyPair keyPair = kpg.generateKeyPair();
            return keyPair;
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static KeyPairBase64 getKeyPairBase64() {
        KeyPair keyPair = Sm2Util.getKeyPair();
        byte[] privateEncoded = keyPair.getPrivate().getEncoded();
        byte[] publicEncoded = keyPair.getPublic().getEncoded();
        String privateEncodedBase64 = CodecUtil.encodeBase64((byte[])privateEncoded);
        String publicEncodedBase64 = CodecUtil.encodeBase64((byte[])publicEncoded);
        return new KeyPairBase64(publicEncodedBase64, privateEncodedBase64);
    }

    public static KeyPairFiles getKeyPairFiles(String pubFilePath, String priFilePath) {
        try {
            KeyPairBase64 keyPairBase64 = Sm2Util.getKeyPairBase64();
            KeyPairFiles keyPairFiles = new KeyPairFiles(pubFilePath, priFilePath);
            FileUtil.writeStringToFile((File)keyPairFiles.getPublicKey(), (String)keyPairBase64.getPublicKey(), (Charset)CharsetUtil.DEFAULT);
            FileUtil.writeStringToFile((File)keyPairFiles.getPublicKey(), (String)keyPairBase64.getPrivateKey(), (Charset)CharsetUtil.DEFAULT);
            return keyPairFiles;
        }
        catch (IOException e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static PublicKey getPublicKeyByBase64(String publicKeyBase64) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM, provider);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(CodecUtil.decodeBase64((String)publicKeyBase64));
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static PrivateKey getPrivateKeyByBase64(String privateKeyBase64) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM, provider);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(CodecUtil.decodeBase64((String)privateKeyBase64));
            return keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static PrivateKey getPrivateKeyByFilePath(String priFilePath) {
        return Sm2Util.getPrivateKeyByFilePath(priFilePath, CharsetUtil.DEFAULT);
    }

    public static PrivateKey getPrivateKeyByFilePath(String priFilePath, Charset encoding) {
        return Sm2Util.getPrivateKeyByFile(FileUtil.getFile((String[])new String[]{priFilePath}), encoding);
    }

    public static PrivateKey getPrivateKeyByFile(File priFile) {
        return Sm2Util.getPrivateKeyByFile(priFile, CharsetUtil.DEFAULT);
    }

    public static PrivateKey getPrivateKeyByFile(File priFile, Charset encoding) {
        try {
            String privateKeyBase64 = FileUtil.readFileToString((File)priFile, (Charset)encoding);
            return Sm2Util.getPrivateKeyByBase64(privateKeyBase64);
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static PublicKey getPublicKeyByFilePath(String pubFilePath) {
        return Sm2Util.getPublicKeyByFilePath(pubFilePath, CharsetUtil.DEFAULT);
    }

    public static PublicKey getPublicKeyByFilePath(String pubFilePath, Charset encoding) {
        return Sm2Util.getPublicKeyByFile(FileUtil.getFile((String[])new String[]{pubFilePath}), encoding);
    }

    public static PublicKey getPublicKeyByFile(File pubFile) {
        return Sm2Util.getPublicKeyByFile(pubFile, CharsetUtil.DEFAULT);
    }

    public static PublicKey getPublicKeyByFile(File pubFile, Charset encoding) {
        try {
            String publicKeyBase64 = FileUtil.readFileToString((File)pubFile, (Charset)encoding);
            return Sm2Util.getPublicKeyByBase64(publicKeyBase64);
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static String encrypt(String data, String publicKeyBase64) {
        return Sm2Util.encrypt(data, publicKeyBase64, CharsetUtil.DEFAULT);
    }

    public static String encrypt(String data, String publicKeyBase64, Charset charset) {
        PublicKey publicKey = Sm2Util.getPublicKeyByBase64(publicKeyBase64);
        return Sm2Util.encrypt(data, publicKey, charset);
    }

    public static String encrypt(String data, PublicKey publicKey) {
        return Sm2Util.encrypt(data, publicKey, CharsetUtil.DEFAULT);
    }

    public static String encrypt(String data, PublicKey publicKey, Charset charset) {
        try {
            SM2Engine sm2Engine = new SM2Engine();
            ECPublicKeyParameters publicKeyParameters = null;
            if (publicKey instanceof BCECPublicKey) {
                BCECPublicKey sm2PubK = (BCECPublicKey)publicKey;
                ECParameterSpec spec = sm2PubK.getParameters();
                ECDomainParameters domainParameters = new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN());
                publicKeyParameters = new ECPublicKeyParameters(sm2PubK.getQ(), domainParameters);
            }
            sm2Engine.init(true, (CipherParameters)new ParametersWithRandom(publicKeyParameters, new SecureRandom()));
            byte[] dataBytes = data.getBytes(charset);
            byte[] encryptBytes = sm2Engine.processBlock(dataBytes, 0, dataBytes.length);
            return CodecUtil.encodeBase64((byte[])encryptBytes);
        }
        catch (InvalidCipherTextException e) {
            throw Exceptions.unchecked((Exception)((Object)e));
        }
    }

    public static String decrypt(String cipherText, String privateKeyBase64) {
        return Sm2Util.decrypt(cipherText, privateKeyBase64, CharsetUtil.DEFAULT);
    }

    public static String decrypt(String cipherText, String privateKeyBase64, Charset charset) {
        PrivateKey privateKey = Sm2Util.getPrivateKeyByBase64(privateKeyBase64);
        return Sm2Util.decrypt(cipherText, privateKey, charset);
    }

    public static String decrypt(String cipherText, PrivateKey privateKey) {
        return Sm2Util.decrypt(cipherText, privateKey, CharsetUtil.DEFAULT);
    }

    public static String decrypt(String cipherText, PrivateKey privateKey, Charset charset) {
        try {
            SM2Engine sm2Engine = new SM2Engine();
            ECPrivateKeyParameters privateKeyParameters = null;
            if (privateKey instanceof BCECPrivateKey) {
                BCECPrivateKey sm2PriK = (BCECPrivateKey)privateKey;
                ECParameterSpec spec = sm2PriK.getParameters();
                ECDomainParameters domainParameters = new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN());
                privateKeyParameters = new ECPrivateKeyParameters(sm2PriK.getD(), domainParameters);
            }
            sm2Engine.init(false, privateKeyParameters);
            byte[] ciphertextBytes = CodecUtil.decodeBase64((String)cipherText);
            byte[] decryptBytes = sm2Engine.processBlock(ciphertextBytes, 0, ciphertextBytes.length);
            return StringUtil.toEncodedString((byte[])decryptBytes, (Charset)charset);
        }
        catch (InvalidCipherTextException e) {
            throw Exceptions.unchecked((Exception)((Object)e));
        }
    }

    public static String getSignatureForSm3(String privateKeyBase64, String data) {
        PrivateKey privateKey = Sm2Util.getPrivateKeyByBase64(privateKeyBase64);
        return Sm2Util.getSignature(SM3_WITH_SM2, privateKey, data);
    }

    public static String getSignatureForSm3(PrivateKey privateKey, String data) {
        return Sm2Util.getSignature(SM3_WITH_SM2, privateKey, data);
    }

    public static String getSignature(String algorithm, PrivateKey privateKey, String data) {
        try {
            Signature signature = Signature.getInstance(algorithm, (Provider)new BouncyCastleProvider());
            signature.initSign(privateKey);
            signature.update(data.getBytes());
            byte[] signatureValue = signature.sign();
            return CodecUtil.encodeHex((byte[])signatureValue);
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static boolean verifySignatureForSm3(String publicKeyBase64, String data, String signatureData) {
        PublicKey publicKey = Sm2Util.getPublicKeyByBase64(publicKeyBase64);
        return Sm2Util.verifySignature(SM3_WITH_SM2, publicKey, data, signatureData);
    }

    public static boolean verifySignatureForSm3(PublicKey publicKey, String data, String signatureData) {
        return Sm2Util.verifySignature(SM3_WITH_SM2, publicKey, data, signatureData);
    }

    public static boolean verifySignature(String algorithm, PublicKey publicKey, String data, String signatureData) {
        try {
            Signature signature = Signature.getInstance(algorithm, (Provider)new BouncyCastleProvider());
            signature.initVerify(publicKey);
            signature.update(data.getBytes());
            return signature.verify(CodecUtil.decodeHex((String)signatureData));
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static String signWithSm3(String privateKeyBase64, String data) {
        PrivateKey privateKey = Sm2Util.getPrivateKeyByBase64(privateKeyBase64);
        return Sm2Util.signWithSm3(privateKey, data);
    }

    public static String signWithSm3(PrivateKey privateKey, String data) {
        try {
            Signature sig = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), "BC");
            sig.initSign(privateKey);
            sig.update(data.getBytes());
            byte[] signatureValue = sig.sign();
            return CodecUtil.encodeHex((byte[])signatureValue);
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static boolean verifyWithSm3(String publicKeyBase64, String data, String signatureData) {
        PublicKey publicKey = Sm2Util.getPublicKeyByBase64(publicKeyBase64);
        return Sm2Util.verifyWithSm3(publicKey, data, signatureData);
    }

    public static boolean verifyWithSm3(PublicKey publicKey, String data, String signatureData) {
        try {
            Signature sig = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), "BC");
            sig.initVerify(publicKey);
            sig.update(data.getBytes());
            return sig.verify(CodecUtil.decodeHex((String)signatureData));
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    static {
        Security.addProvider(provider);
    }
}

