/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.security.gm;

import cn.net.wanmo.common.charset.CharsetUtil;
import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.util.Exceptions;
import cn.net.wanmo.common.util.StringUtil;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Sm4Util {
    public static final String ALGORITHM_NAME = "SM4";
    public static final String DEFAULT_KEY = "wan_mo_seed";
    public static final int DEFAULT_KEY_SIZE = 128;

    public static String generateKey() {
        return Sm4Util.generateKey(DEFAULT_KEY, 128);
    }

    public static String generateKey(String seed) {
        return Sm4Util.generateKey(seed, 128);
    }

    public static String generateKey(String seed, int keySize) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM_NAME, "BC");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            if (StringUtil.isNotBlank((CharSequence)seed)) {
                random.setSeed(seed.getBytes());
            }
            kg.init(keySize, random);
            byte[] encoded = kg.generateKey().getEncoded();
            return CodecUtil.encodeBase64((byte[])encoded);
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static String generateIv() {
        String randomCode = StringUtil.getRandomCode((int)16);
        return CodecUtil.encodeBase64((String)randomCode);
    }

    public static String encryptCBC(String key, String iv, String data) {
        return Sm4Util.encrypt("SM4/CBC/PKCS5PADDING", key, iv, data);
    }

    public static String decryptCBC(String key, String iv, String data) {
        return Sm4Util.decrypt("SM4/CBC/PKCS5PADDING", key, iv, data);
    }

    public static String encryptECB(String key, String data) {
        return Sm4Util.encrypt("SM4/ECB/PKCS5PADDING", key, "", data);
    }

    public static String decryptECB(String key, String data) {
        return Sm4Util.decrypt("SM4/ECB/PKCS5PADDING", key, "", data);
    }

    public static String encrypt(String algorithmName, String key, String iv, String data) {
        byte[] keyBytes = CodecUtil.decodeBase64((String)key);
        byte[] ivBytes = CodecUtil.decodeBase64((String)iv);
        byte[] dataBytes = data.getBytes(CharsetUtil.DEFAULT);
        byte[] encryptBytes = Sm4Util.sm4core(algorithmName, 1, keyBytes, ivBytes, dataBytes);
        return CodecUtil.encodeBase64((byte[])encryptBytes);
    }

    public static String decrypt(String algorithmName, String key, String iv, String data) {
        byte[] keyBytes = CodecUtil.decodeBase64((String)key);
        byte[] ivBytes = CodecUtil.decodeBase64((String)iv);
        byte[] dataBytes = CodecUtil.decodeBase64((String)data);
        byte[] decryptBytes = Sm4Util.sm4core(algorithmName, 2, keyBytes, ivBytes, dataBytes);
        return StringUtil.toEncodedString((byte[])decryptBytes, (Charset)CharsetUtil.DEFAULT);
    }

    private static byte[] sm4core(String algorithmName, int type, byte[] key, byte[] iv, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(algorithmName, "BC");
            SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
            if (algorithmName.contains("/ECB/")) {
                cipher.init(type, sm4Key);
            } else {
                IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
                cipher.init(type, (Key)sm4Key, ivParameterSpec);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

