package cn.net.wanmo.plugin.spring.config;

import cn.net.wanmo.common.util.Ini4jUtil;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class SpringConfig {

    /**
     * 配置 spring 部分
     */
    private static Profile.Section section = null;

    /**
     * 优先从默认配置文件 wanmo-config.ini 获取;
     * 如果没有，则从指定配置文件 wanmo-config-spring.ini 获取;
     * @return 配置spring 的 Section
     */
    private static Profile.Section getSection() {
        if (section == null) {
            final String section_name = "spring";

            section = Ini4jUtil.getSection(section_name); // 从默认配置文件获取
            if (section == null) { // 从指定配置文件获取
                Ini iniAliyun = Ini4jUtil.getIni("wanmo-config-spring.ini");
                section = Ini4jUtil.getSection(iniAliyun, section_name);
            }
        }

        return section;
    }
}
