/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.plugin.spring.util;

import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class SpringUtil
implements BeanFactoryPostProcessor,
ApplicationContextAware,
DisposableBean {
    private static ApplicationContext applicationContext;
    private static ConfigurableListableBeanFactory beanFactory;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (SpringUtil.applicationContext == null) {
            SpringUtil.applicationContext = applicationContext;
        }
        System.out.println("---------------------------------------------------------------------");
        System.out.println("========ApplicationContext \u914d\u7f6e\u6210\u529f,\u5728\u666e\u901a\u7c7b\u53ef\u4ee5\u901a\u8fc7\u8c03\u7528 SpringUtils.getAppContext() \u83b7\u53d6\u5bf9\u8c61========");
        System.out.println("---------------------------------------------------------------------");
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (SpringUtil.beanFactory == null) {
            SpringUtil.beanFactory = beanFactory;
        }
        System.out.println("---------------------------------------------------------------------");
        System.out.println("========ConfigurableBeanFactory \u914d\u7f6e\u6210\u529f, \u5728\u666e\u901a\u7c7b\u53ef\u4ee5\u901a\u8fc7\u8c03\u7528 SpringUtils.getBeanFactory() \u83b7\u53d6\u5bf9\u8c61========");
        System.out.println("---------------------------------------------------------------------");
    }

    public static ApplicationContext getAppContext() {
        SpringUtil.assertContextInjected();
        return applicationContext;
    }

    public static ConfigurableListableBeanFactory getBeanFactory() {
        SpringUtil.assertBeanFactoryInjected();
        return beanFactory;
    }

    public static Object getBean(String name) {
        SpringUtil.assertContextInjected();
        return SpringUtil.getAppContext().getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        SpringUtil.assertContextInjected();
        return (T)SpringUtil.getAppContext().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        SpringUtil.assertContextInjected();
        return (T)SpringUtil.getAppContext().getBean(name, clazz);
    }

    public static Object getBeanFromFactory(String name) {
        SpringUtil.assertBeanFactoryInjected();
        return SpringUtil.getBeanFactory().getBean(name);
    }

    public static <T> T getBeanFromFactory(Class<T> clazz) {
        SpringUtil.assertBeanFactoryInjected();
        return (T)SpringUtil.getBeanFactory().getBean(clazz);
    }

    private static void assertContextInjected() {
        if (applicationContext == null) {
            throw new RuntimeException("applicationContext \u5c5e\u6027\u672a\u6ce8\u5165, \u8bf7\u5728 applicationContext.xml \u4e2d\u5b9a\u4e49 SpringUtil.");
        }
    }

    private static void assertBeanFactoryInjected() {
        if (beanFactory == null) {
            throw new RuntimeException("beanFactory \u5c5e\u6027\u672a\u6ce8\u5165, \u8bf7\u5728 applicationContext.xml \u4e2d\u5b9a\u4e49 SpringUtil.");
        }
    }

    public void destroy() throws Exception {
        applicationContext = null;
        beanFactory = null;
    }

    public static HttpServletRequest getRequest() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        }
        catch (Exception e) {
            return null;
        }
    }
}

