/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.plugin.spring.util.http;

import cn.net.wanmo.common.util.IdGen;
import cn.net.wanmo.plugin.spring.util.SpringUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtil {
    private static final Logger logger = LoggerFactory.getLogger(RestTemplateUtil.class);
    private static final RestTemplate restTemplate = SpringUtil.getBean(RestTemplate.class);

    public static <T> T getForObject(String url, Class<T> responseType) {
        return (T)restTemplate.getForObject(url, responseType, new Object[0]);
    }

    public static <T> T getForEntity(String url, Class<T> responseType) {
        return (T)restTemplate.getForEntity(url, responseType, new Object[0]).getBody();
    }

    public static String getForString(String url) {
        RestTemplateUtil.assertRestTemplate();
        String response = (String)restTemplate.getForObject(url, String.class, new Object[0]);
        logger.debug("response = {}", (Object)response);
        return response;
    }

    public static String postForString(String url, String params) {
        RestTemplateUtil.assertRestTemplate();
        HttpHeaders headers = new HttpHeaders();
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String response = (String)restTemplate.postForObject(url, (Object)request, String.class, new Object[0]);
        logger.debug("response = {}", (Object)response);
        return response;
    }

    public static File postForFile(String url, String params) throws IOException {
        int len;
        RestTemplateUtil.assertRestTemplate();
        HttpHeaders headers = new HttpHeaders();
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.postForEntity(url, (Object)request, Resource.class, new Object[0]);
        InputStream inputStream = ((Resource)responseEntity.getBody()).getInputStream();
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        File tempFile = File.createTempFile(IdGen.uuid(), ".jpeg");
        FileOutputStream os = new FileOutputStream(tempFile);
        byte[] arr = new byte[1024];
        while ((len = bis.read(arr)) != -1) {
            ((OutputStream)os).write(arr, 0, len);
            os.flush();
        }
        ((OutputStream)os).close();
        bis.close();
        inputStream.close();
        return tempFile;
    }

    public static String postJsonForString(String url, String params) {
        RestTemplateUtil.assertRestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String response = (String)restTemplate.postForObject(url, (Object)request, String.class, new Object[0]);
        logger.debug("response = {}", (Object)response);
        return response;
    }

    public static File postJsonForFile(String url, String params) throws IOException {
        int len;
        RestTemplateUtil.assertRestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.postForEntity(url, (Object)request, Resource.class, new Object[0]);
        InputStream inputStream = ((Resource)responseEntity.getBody()).getInputStream();
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        File tempFile = File.createTempFile(IdGen.uuid(), ".jpeg");
        FileOutputStream os = new FileOutputStream(tempFile);
        byte[] arr = new byte[1024];
        while ((len = bis.read(arr)) != -1) {
            ((OutputStream)os).write(arr, 0, len);
            os.flush();
        }
        ((OutputStream)os).close();
        bis.close();
        inputStream.close();
        return tempFile;
    }

    private static void assertRestTemplate() {
        Assert.notNull((Object)restTemplate, (String)"\u8bf7\u5f00\u542fSpring\u6ce8\u89e3\u626b\u63cf\u529f\u80fd\u540e\u91cd\u8bd5...");
    }
}

