package cn.net.wanmo.plugin.wechat.offiaccount;

import cn.net.wanmo.common.util.Ini4jUtil;
import org.ini4j.Ini;
import org.ini4j.Profile.Section;

/**
 * 微信公众号 配置信息
 */
public class Config {
	public static String getAppID() {
		return getSection().get("app_id");
	}

	public static String getAppSecret() {
		return getSection().get("app_secret");
	}

	/**
	 * 微信公众号配置部分
	 */
	private static Section section = null;

	/**
	 * 优先从默认配置文件 wanmo-config.ini 获取;
	 * 如果没有，则从指定配置文件 wanmo-config-wechat-offiaccount.ini 获取;
	 * @return 微信公众号的 配置 Section
	 */
	private static Section getSection() {
		if (section == null) {
			final String section_name = "wechat-offiaccount";

			section = Ini4jUtil.getSection(section_name); // 从默认配置文件获取
			if (section == null) { // 从指定配置文件获取
				Ini ini = Ini4jUtil.getIni("wanmo-config-wechat-offiaccount.ini");
				section = Ini4jUtil.getSection(ini, section_name);
			}
		}

		return section;
	}
}

