package cn.net.wanmo.plugin.wechat.offiaccount.token;

import cn.net.wanmo.plugin.wechat.offiaccount.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 定时获取微信access_token的线程
 */
public class AccessTokenRunnable implements Runnable {
	private static Logger logger = LoggerFactory.getLogger(AccessTokenRunnable.class);
	
	public static AccessToken accessToken = null;

	public void run() {
		while (true) {
			try {
				accessToken = AccessTokenUtil.getAccessToken(Config.getAppID(), Config.getAppSecret());
				if (accessToken != null && accessToken.getErrcode() == 0 ) {
					logger.info("获取access_token成功，有效时长{}秒 token:{}", accessToken.getExpires_in(), accessToken.getAccess_token());
					// 休眠7000秒
					Thread.sleep((accessToken.getExpires_in() - 200) * 1000);
				} else {
					// // 获取token失败
					logger.error("获取token失败 errcode:{} errmsg:{}", accessToken.getErrcode(), accessToken.getErrmsg());
					// 如果access_token为null，60秒后再获取
					Thread.sleep(60 * 1000);
				}
			} catch (InterruptedException e) {
				try {
					Thread.sleep(60 * 1000);
				} catch (InterruptedException e1) {
					logger.error("{}", e1);
				}
				logger.error("{}", e);
			}
		}
	}
	

}
