package cn.net.wanmo.plugin.wechat.offiaccount.token;

import cn.net.wanmo.common.util.http.HttpURLConnectionUtil;
import cn.net.wanmo.common.util.json.JacksonUtil;
import cn.net.wanmo.common.util.StringUtil;

public class AccessTokenUtil {
	
	// 获取access_token的接口地址（GET） 限200（次/天）
	public final static String access_token_url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET";

	/**
	 * 获取access_token
	 * 
	 * @param appid
	 *            凭证
	 * @param appsecret
	 *            密钥
	 * @return
	 */
	public static AccessToken getAccessToken(String appid, String appsecret) {
		AccessToken accessToken = new AccessToken();
		String requestUrl = access_token_url.replace("APPID", appid).replace("APPSECRET", appsecret);
		String jsonStr = HttpURLConnectionUtil.sendGet(requestUrl);
		// // 如果请求成功
		if (StringUtil.isNotBlank(jsonStr)) {
			try {
				accessToken = (AccessToken) JacksonUtil.readJson(jsonStr, AccessToken.class);
			} catch (Exception e) {
				accessToken = null;
			}
		}
		return accessToken;
	}
	
}
