package cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book;

import cn.net.wanmo.common.restful.body.Req;
import com.alibaba.fastjson.JSONObject;

public class ListIdReq extends Req {

    /**
     * 生成请求体
     * @return 请求体
     */
    public static ListIdReq build() {
        return build(null, null);
    }

    /**
     * 生成请求体
     * @param limit 预期请求的数据量
     * @return 请求体
     */
    public static ListIdReq build(Integer limit) {
        return build(limit, null);
    }

    /**
     * 生成请求体
     * @param limit 预期请求的数据量
     * @param cursor 分页查询的游标
     * @return 请求体
     */
    public static ListIdReq build(Integer limit, String cursor) {
        ListIdReq req = new ListIdReq();
        req.setLimit(limit);
        req.setCursor(cursor);
        return req;
    }

    @Override
    public String toJSONString() {
        JSONObject params = new JSONObject();
        params.put("cursor", getCursor());
        params.put("limit", getLimit());
        return params.toJSONString();
    }

    /** 访问令牌 */
    private String accessToken;

    /** 用于分页查询的游标，字符串类型，由上一次调用返回，首次调用不填 */
    private String cursor;
    /** 分页，预期请求的数据量，取值范围 1 ~ 10000 */
    private Integer limit;

    public ListIdReq() {
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getCursor() {
        return cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public Integer getLimit() {
        return limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }
}
