package cn.net.wanmo.common.weixin.work.inner.server_api.pojo.message_push.app;

import com.alibaba.fastjson.JSONObject;

/**
 * 图片消息
 */
public class ImageMessageReq extends MessageReq {

    public static ImageMessageReq build(String agentId, String mediaId) {
        ImageMessageReq req = new ImageMessageReq();
        req.setAgentId(agentId);
        req.getImage().setMediaId(mediaId);
        return req;
    }

    @Override
    public String toJSONString() {
        JSONObject params = new JSONObject();
        params.put("touser", getToUser());
        params.put("toparty", getToParty());
        params.put("totag", getToTag());
        params.put("msgtype", getMsgType().getValue());
        params.put("agentid", getAgentId());
        params.put("image", getImage().toJSONObject());
        params.put("safe", getSafe());
        params.put("enable_duplicate_check", getEnableDuplicateCheck());
        params.put("duplicate_check_interval", getDuplicateCheckInterval());
        return params.toJSONString();
    }

    /** 消息内容 */
    private Image image;

    public ImageMessageReq() {
        this.msgType = MsgType.image;
        this.image = new Image();
    }

    public Image getImage() {
        return image;
    }

    public void setImage(Image image) {
        this.image = image;
    }


    public class Image {

        /** 图片媒体文件id，可以调用上传临时素材接口获取 */
        private String mediaId;

        public Image() {
        }

        public Image(String mediaId) {
            this.mediaId = mediaId;
        }

        public String getMediaId() {
            return mediaId;
        }

        public void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }

        public JSONObject toJSONObject() {
            JSONObject object = new JSONObject();
            object.put("media_id", getMediaId());
            return object;
        }
    }
}
