package cn.net.wanmo.common.weixin.work.third.util;

import cn.net.wanmo.common.codec.CodecUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 企业微信 工具包
 */
public class WorkThirdUtil {
    private static Logger logger = LoggerFactory.getLogger(WorkThirdUtil.class);

    /**
     * 获取 oauth2 url
     * @param appId 即 suite_id
     * @param redirectUri 授权后重定向的回调链接地址
     * @param scope 应用授权作用域： snsapi_base：静默授权，snsapi_privateinfo：手动授权
     * @param state 重定向后会带上state参数，企业可以填写a-zA-Z0-9的参数值，长度不可超过128个字节
     * @return url
     */
    public static String creatOauth2Url(String appId, String redirectUri, String scope, String state) {
        redirectUri = CodecUtil.urlEncode(redirectUri);

        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid={APPID}&redirect_uri={REDIRECT_URI}&response_type=code&scope={SCOPE}&state={STATE}#wechat_redirect";
        url = url.replace("{APPID}", appId).replace("{REDIRECT_URI}", redirectUri).replace("{SCOPE}", scope).replace("{STATE}", state);

        logger.debug("第三方应用 构造网页授权链接 url: {}", url);
        return url;
    }

}
