/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.weixin.work.inner.server_api.util;

import cn.net.wanmo.common.pojo.InterfaceResult;
import cn.net.wanmo.common.restful.SendUtil;
import cn.net.wanmo.common.restful.body.Req;
import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.weixin.work.inner.pojo.Agent;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.server_ip.ApiDomainIpReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.server_ip.ApiDomainIpRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.server_ip.CallbackIpReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.server_ip.CallbackIpRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.token.AccessTokenReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.token.AccessTokenRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkInnerUtil {
    private static Logger logger = LoggerFactory.getLogger(WorkInnerUtil.class);

    public static InterfaceResult<AccessTokenRes> getAccessToken(AccessTokenReq req) {
        String msgPre = "\u4f01\u4e1a\u5fae\u4fe1\u63a5\u53e3 \u83b7\u53d6\u8bbf\u95ee\u4ee4\u724c: ";
        req.setBody(null);
        AccessTokenRes res = new AccessTokenRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=ID&corpsecret=SECRET";
        url = url.replace("ID", req.getCorpId()).replace("SECRET", req.getSecret());
        return SendUtil.sendGet((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger);
    }

    public static InterfaceResult<ApiDomainIpRes> getApiDomainIp(Agent agent, ApiDomainIpReq req) {
        String logPrevDesc = agent.getLogPrevDesc();
        String token = agent.takeToken();
        return WorkInnerUtil.getApiDomainIp(logPrevDesc, token, req);
    }

    public static InterfaceResult<ApiDomainIpRes> getApiDomainIp(String logPrevDesc, String token, ApiDomainIpReq req) {
        String msgPre = logPrevDesc + ": \u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u63a5\u53e3IP\u6bb5: ";
        req.setBody(null);
        ApiDomainIpRes res = new ApiDomainIpRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/get_api_domain_ip?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);
        return SendUtil.sendGet((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger);
    }

    public static InterfaceResult<CallbackIpRes> getCallbackIp(Agent agent, CallbackIpReq req) {
        String logPrevDesc = agent.getLogPrevDesc();
        String token = agent.takeToken();
        return WorkInnerUtil.getCallbackIp(logPrevDesc, token, req);
    }

    public static InterfaceResult<CallbackIpRes> getCallbackIp(String logPrevDesc, String token, CallbackIpReq req) {
        String msgPre = logPrevDesc + ": \u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u56de\u8c03IP\u6bb5: ";
        req.setBody(null);
        CallbackIpRes res = new CallbackIpRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/getcallbackip?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);
        return SendUtil.sendGet((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger);
    }
}

