/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.weixin.work.inner.server_api.util.authentication;

import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.pojo.InterfaceResult;
import cn.net.wanmo.common.restful.SendUtil;
import cn.net.wanmo.common.restful.body.Req;
import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.weixin.work.inner.pojo.Agent;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.authentication.web_auth.GetUserDetailReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.authentication.web_auth.GetUserDetailRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.authentication.web_auth.GetUserinfoReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.authentication.web_auth.GetUserinfoRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.authentication.web_auth.Oauth2UrlReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.authentication.web_auth.Oauth2UrlRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAuthUtil {
    private static Logger logger = LoggerFactory.getLogger(WebAuthUtil.class);

    public static Oauth2UrlRes buildPageOauth2Url(Oauth2UrlReq req) {
        String corpId = req.getCorpId();
        String agentId = req.getAgentId();
        String redirectUri = CodecUtil.urlEncode((String)req.getRedirectUri());
        String scope = req.getScope().getValue();
        String state = req.getState();
        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=CORPID&redirect_uri=REDIRECT_URI&response_type=code&scope=SCOPE&state=STATE&agentid=AGENTID#wechat_redirect";
        url = url.replace("CORPID", corpId).replace("AGENTID", agentId).replace("REDIRECT_URI", redirectUri).replace("SCOPE", scope).replace("STATE", state);
        logger.debug("\u81ea\u5efa\u5e94\u7528 \u6784\u9020\u7f51\u9875\u6388\u6743\u94fe\u63a5 url: {}", (Object)url);
        return new Oauth2UrlRes(url);
    }

    public static InterfaceResult<GetUserinfoRes> getUserinfo(Agent agent, GetUserinfoReq req) {
        String logPrevDesc = agent.getLogPrevDesc();
        String token = agent.takeToken();
        return WebAuthUtil.getUserinfo(logPrevDesc, token, req);
    }

    public static InterfaceResult<GetUserinfoRes> getUserinfo(String logPrevDesc, String token, GetUserinfoReq req) {
        String msgPre = logPrevDesc + ": \u7f51\u9875\u6388\u6743\u767b\u5f55 \u83b7\u53d6\u8bbf\u95ee\u7528\u6237\u8eab\u4efd: ";
        req.setBody(null);
        GetUserinfoRes res = new GetUserinfoRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserinfo?access_token=ACCESS_TOKEN&code=CODE";
        url = url.replace("ACCESS_TOKEN", token).replace("CODE", req.getCode());
        return SendUtil.sendGet((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger);
    }

    public static InterfaceResult<GetUserDetailRes> getUserDetail(Agent agent, GetUserDetailReq req) {
        String logPrevDesc = agent.getLogPrevDesc();
        String token = agent.takeToken();
        return WebAuthUtil.getUserDetail(logPrevDesc, token, req);
    }

    public static InterfaceResult<GetUserDetailRes> getUserDetail(String logPrevDesc, String token, GetUserDetailReq req) {
        String msgPre = logPrevDesc + ": \u7f51\u9875\u6388\u6743\u767b\u5f55 \u83b7\u53d6\u8bbf\u95ee\u7528\u6237\u654f\u611f\u4fe1\u606f: ";
        req.setBody(req.toJSONString());
        GetUserDetailRes res = new GetUserDetailRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserdetail?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);
        return SendUtil.sendPostForJson((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger);
    }
}

