(function (window) {

    /**
     * 得到元素的当前某个样式
     * @param element
     * @param stylename
     * @returns {*}
     */
    function getStyle(element, styleName) {
        if (element.currentStyle) {
            return element.currentStyle[stylename]; // ie下独有 不兼容部分
        } else {
            return window.getComputedStyle(element, false)[stylename];
        }
    }

    /**
     * wx.config()
     * @param options
     */
    function configInit(options) {
        const debug = options.param.debug;
        const appId = options.param.appId;
        const timestamp = options.param.timestamp;
        const nonceStr = options.param.nonceStr;
        const signature = options.param.signature;
        const jsApiList = options.param.jsApiList;

        wx.config({
            beta: true,// 必须这么写，否则wx.invoke调用形式的jsapi会有问题
            debug: debug, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
            appId: appId, // 必填，企业微信的corpID，必须是本企业的corpID，不允许跨企业使用
            timestamp: timestamp, // 必填，生成签名的时间戳
            nonceStr: nonceStr, // 必填，生成签名的随机串
            signature: signature,// 必填，签名，见 附录-JS-SDK使用权限签名算法
            jsApiList: jsApiList // 必填，需要使用的JS接口列表，凡是要调用的接口都需要传进来
        });
        wx.ready(function(){
            // config信息验证后会执行ready方法，所有接口调用都必须在config接口获得结果之后，config是一个客户端的异步操作，所以如果需要在页面加载时就调用相关接口，则须把相关接口放在ready函数中调用来确保正确执行。对于用户触发时才调用的接口，则可以直接调用，不需要放在ready函数中。
            if (options.ready === undefined) {
                return;
            }
            options.ready();
        });
        wx.error(function(res){
            // config信息验证失败会执行error函数，如签名过期导致验证失败，具体错误信息可以打开config的debug模式查看，也可以在返回的res参数中查看，对于SPA可以在这里更新签名。
            if (options.error === undefined) {
                return;
            }
            options.error(res);
        });
    }

    /**
     * wx.agentConfig()
     * @param options
     */
     function agentConfigInit (options) {
        const corpid = options.param.corpid;
        const agentid = options.param.agentid;
        const timestamp = options.param.timestamp;
        const nonceStr = options.param.nonceStr;
        const signature = options.param.signature;
        const jsApiList = options.param.jsApiList;

        wx.agentConfig({
            corpid: corpid, // 必填，企业微信的corpid，必须与当前登录的企业一致
            agentid: agentid, // 必填，企业微信的应用id （e.g. 1000247）
            timestamp: timestamp, // 必填，生成签名的时间戳
            nonceStr: nonceStr, // 必填，生成签名的随机串
            signature: signature,// 必填，签名，见附录-JS-SDK使用权限签名算法
            jsApiList: jsApiList, //必填，传入需要使用的接口名称
            success: function(res) {
                if (options.success === undefined) {
                    return;
                }
                options.success(res);
            },
            fail: function(res) {
                if (options.fail === undefined) {
                    return;
                }
                options.fail(res);
            }
        });
    }

    /**
     * 构造函数
     * @param context
     * @returns {Wechat.init}
     * @constructor
     */
    function Wechat(context) {
        return new Wechat.prototype.init(context);
    }

    Wechat.prototype.init = function (context) {
        this.elements = []; //返回值
        const type = typeof context;

        if (type == 'function') {
            context(this);
        } else if (type == 'string') {

        } else if (type == 'object') {
            this.elements.push(context)
        }
    }

    Wechat.prototype.init.prototype = Wechat.prototype;
    Wechat.prototype.configInit = configInit;
    Wechat.prototype.agentConfigInit = agentConfigInit;

    /**
     * 原型 遍历元素
     * @param fn
     */
    Wechat.prototype.each = function (fn) {
        for (let i = 0; i < this.elements.length; i++) {
            fn(i, this.elements[i]);
        }
    }

    /**
     * 获取元素样式或者设置元素样式
     * @param styleName
     * @param styleValue
     * @returns {*}
     */
    Wechat.prototype.css = function (styleName, styleValue) {
        if (arguments.length == 2) {
            this.each(function (i, ele) {
                ele.style[styleName] = styleName;
            })
        } else {
            return getStyle(this.elements[0], styleName);
        }
    }

    /**
     * 获取或设置属性
     * @param attrName
     * @param attrValue
     * @returns {string}
     */
    Wechat.prototype.attr = function (attrName, attrValue) {
        if (attrValue) {
            this.each(function (i, ele) {
                ele.setAttribute(attrName, attrValue);
            });
        } else {
            return this.elements[0].getAttribute(attrName);
        }
    }

    window.Wechat = Wechat;
})(window)