package cn.net.wanmo.plugin.baidu.dwz;

import com.google.gson.Gson;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * 百度短网址 还原工具类<br>
 * API: https://dwz.cn/console/apidoc
 */
public class DwzQueryUtil {
	/** 短网址还原接口 */
	private final static String QUERY_API = "https://dwz.cn/admin/v2/query";

	/** 由数字和字母组成的32位字符，在调用 API接口 时，用于鉴权 */
	private static final String TOKEN = "7a214e0941dfa7eb1bf438090103bc36";

	/**
	 * 还原长网址短网址
	 *
	 * @param shortUrl 短网址
	 * @return UrlResponse
	 *
	 */
	public static UrlResponse queryLongUrl(String shortUrl) {
		UrlResponse urlResponse = new UrlResponse();

		BufferedReader reader = null;
		try {
			// 创建连接
			URL url = new URL(QUERY_API);
			HttpURLConnection connection = (HttpURLConnection) url.openConnection();
			connection.setDoOutput(true);
			connection.setDoInput(true);
			connection.setUseCaches(false);
			connection.setInstanceFollowRedirects(true);
			connection.setRequestMethod("POST"); // 设置请求方式
			connection.setRequestProperty("Content-Type", "application/json"); // 设置发送数据的格式
			connection.setRequestProperty("Token", TOKEN); // 设置发送数据的格式");

			// 发起请求
			connection.connect();
			OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8"); // utf-8编码
			String params = "{\"shortUrl\":\"" + shortUrl + "\"}";
			out.append(params);
			out.flush();
			out.close();

			// 读取响应
			reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
			String line;
			String res = "";
			while ((line = reader.readLine()) != null) {
				res += line;
			}
			reader.close();

			// 抽取生成长网址
			urlResponse = new Gson().fromJson(res, UrlResponse.class);
		} catch (IOException e) {
			urlResponse.setCode(-999);
			urlResponse.setErrMsg(e.getMessage());
		}
		return urlResponse; // TODO：自定义错误信息
	}

	public static void main(String[] args) {
		UrlResponse urlResponse = queryLongUrl("https://dwz.cn/5SWesEi7");
		System.out.println(urlResponse);

	}
}