package cn.net.wanmo.plugin.baidu.config;

import cn.net.wanmo.common.util.Ini4jUtil;
import org.ini4j.Ini;
import org.ini4j.Profile.Section;

/**
 * 百度云配置信息
 */
public class BaiduConfig {

	/**
	 * 获取 百度 accessKeyId
	 * 
	 * @return
	 */
	public static String getAccessKeyId() {
		String uploadDir = getSection().get("accessKeyId");
		return uploadDir;
	}

	/**
	 * 获取 百度 accessKeySecret
	 * 
	 * @return
	 */
	public static String getAccessKeySecret() {
		String uploadDir = getSection().get("accessKeySecret");
		return uploadDir;
	}

	/**
	 * 配置 百度 部分
	 */
	private static Section section = null;

	/**
	 * 优先从默认配置文件 wanmo-config.ini 获取;
	 * 如果没有，则从指定配置文件 wanmo-config-baidu.ini 获取;
	 * @return 配置百度的 Section
	 */
	private static Section getSection() {
		if (section == null) {
			final String section_name = "baidu";

			section = Ini4jUtil.getSection(section_name); // 从默认配置文件获取
			if (section == null) { // 从指定配置文件获取
				Ini iniAliyun = Ini4jUtil.getIni("wanmo-config-baidu.ini");
				section = Ini4jUtil.getSection(iniAliyun, section_name);
			}
		}

		return section;
	}

}
