package cn.net.wanmo.plugin.baidu.dwz;

import com.google.gson.Gson;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * 百度短网址 生成工具类<br>
 * API: https://dwz.cn/console/apidoc
 */
public class DwzCreateUtil {
	/** 短网址生成接口 */
	private final static String CREATE_API = "https://dwz.cn/admin/v2/create";
	/** 由数字和字母组成的32位字符，在调用 API接口 时，用于鉴权 */
	private static final String TOKEN = "7a214e0941dfa7eb1bf438090103bc36";

	/** 有效期：长期，默认值 */
	public static String TermOfValidity_long_term = "long-term";
	/** 有效期：1年 */
	public static String TermOfValidity_1_year = "1-year";

	/**
	 * 创建短网址， 默认有效期1年
	 *
	 * @param longUrl 长网址：即原网址 termOfValidity 有效期：默认值为long-term
	 * @return 成功：短网址 失败：返回空字符串
	 */
	public static UrlResponse createShortUrl(String longUrl) {
		return createShortUrl(longUrl, TermOfValidity_long_term);
	}

	/**
	 * 创建短网址
	 *
	 * @param longUrl 长网址：即原网址 termOfValidity 有效期：默认值为long-term
	 * @return 成功：短网址 失败：返回空字符串
	 */
	public static UrlResponse createShortUrl(String longUrl, String termOfValidity) {
		UrlResponse urlResponse = new UrlResponse();
		try {
			BufferedReader reader = null;

			URL url = new URL(CREATE_API);
			HttpURLConnection connection = (HttpURLConnection) url.openConnection();
			connection.setDoOutput(true);
			connection.setDoInput(true);
			connection.setUseCaches(false);
			connection.setInstanceFollowRedirects(true);
			connection.setRequestMethod("POST"); // 设置请求方式
			connection.setRequestProperty("Content-Type", "application/json"); // 设置发送数据的格式
			connection.setRequestProperty("Token", TOKEN); // 设置发送数据的格式");

			// 发起请求
			connection.connect();
			OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8"); // utf-8编码
			// 创建连接
			String params = "{\"Url\":\"" + longUrl + "\",\"TermOfValidity\":\"" + termOfValidity + "\"}";
			out.append(params);
			out.flush();
			out.close();

			// 读取响应
			reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
			String line;
			String res = "";
			while ((line = reader.readLine()) != null) {
				res += line;
			}
			reader.close();

			// 抽取生成短网址
			urlResponse = new Gson().fromJson(res, UrlResponse.class);

		} catch (IOException e) {
			urlResponse.setCode(-999);
			urlResponse.setErrMsg(e.getMessage());
		}
		return urlResponse;
	}

	public static void main(String[] args) {
		UrlResponse urlResponse = createShortUrl("http://zhiang.jeeweb.com.cn/", TermOfValidity_1_year);
		System.out.println(urlResponse);
	}
}
