package cn.net.wanmo.plugin.baidu.dwz;

import cn.net.wanmo.common.util.StringUtil;
import com.google.gson.Gson;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * 百度短网址 删除工具类<br>
 * 短网址删除成功后，因服务缓存机制，短时间内依然可以访问，最长1小时后，删除完全生效<br>
 * API: https://dwz.cn/console/apidoc
 */
public class DwzDeleteUtil {
	/** 短网址刪除接口 */
	private final static String DELETE_API = "https://dwz.cn/api/v3/short-urls/{short_path}";
	/** 由数字和字母组成的32位字符，在调用 API接口 时，用于鉴权 */
	private static final String TOKEN = "7a214e0941dfa7eb1bf438090103bc36";

	/**
	 * 刪除短网址
	 * 
	 * @param shortPath 短网址
	 * @return UrlResponse
	 */
	public static UrlResponse deleteShortUrl(String shortPath) {
		String shortPathSuffix = shortPath.substring(shortPath.lastIndexOf("/") + 1);
		return deleteShortUrlSuffix(shortPathSuffix);
	}

	/**
	 * 刪除短网址
	 * 
	 * @param shortPathSuffix 短网址后缀，如http://dwz.cn/testPath中的testPath
	 * @return UrlResponse
	 */
	public static UrlResponse deleteShortUrlSuffix(String shortPathSuffix) {
		UrlResponse urlResponse = new UrlResponse();
		BufferedReader reader = null;
		try {
			// 创建连接
			URL url = new URL(StringUtil.replace(DELETE_API, "{short_path}", shortPathSuffix));
			HttpURLConnection connection = (HttpURLConnection) url.openConnection();
			connection.setDoOutput(true);
			connection.setDoInput(true);
			connection.setUseCaches(false);
			connection.setInstanceFollowRedirects(true);
			connection.setRequestMethod("DELETE"); // 设置请求方式
			connection.setRequestProperty("Dwz-Token", TOKEN); // 设置发送数据的格式");

			// 发起请求
			connection.connect();
			OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8"); // UTF-8编码
			out.flush();
			out.close();

			// 读取响应
			reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
			String line;
			String res = "";
			while ((line = reader.readLine()) != null) {
				res += line;
			}
			reader.close();

			// 返回响应
			urlResponse = new Gson().fromJson(res, UrlResponse.class);
		} catch (IOException e) {
			urlResponse.setCode(-999);
			urlResponse.setErrMsg(e.getMessage());
		}
		return urlResponse;
	}

	public static void main(String[] args) {
		UrlResponse res = deleteShortUrl("https://dwz.cn/5SWesEi7");
		System.out.println(res);
	}
}
