/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jeeweb.common.util;

import cn.com.jeeweb.common.util.CharsetUtil;
import cn.com.jeeweb.common.util.Exceptions;
import cn.com.jeeweb.common.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringEscapeUtils;

public class CodecUtil {
    public static String encodeHex(byte[] input) {
        return new String(Hex.encodeHex((byte[])input));
    }

    public static byte[] decodeHex(String input) {
        try {
            return Hex.decodeHex((char[])input.toCharArray());
        }
        catch (DecoderException e) {
            throw Exceptions.unchecked((Exception)((Object)e));
        }
    }

    public static String encodeBase64(byte[] bytes) {
        byte[] encodeBase64 = Base64.encodeBase64((byte[])bytes);
        return StringUtil.toEncodedString((byte[])encodeBase64, (Charset)CharsetUtil.DEFAULT_CHARSET);
    }

    public static String encodeBase64(String input) {
        byte[] bytes = input.getBytes(CharsetUtil.DEFAULT_CHARSET);
        return CodecUtil.encodeBase64(bytes);
    }

    public static byte[] decodeBase64(String input) {
        byte[] bytes = input.getBytes(CharsetUtil.DEFAULT_CHARSET);
        return Base64.decodeBase64((byte[])bytes);
    }

    public static String decodeBase64String(String input) {
        byte[] decodeBase64 = CodecUtil.decodeBase64(input);
        return StringUtil.toEncodedString((byte[])decodeBase64, (Charset)CharsetUtil.DEFAULT_CHARSET);
    }

    public static String escapeHtml(String html) {
        return StringEscapeUtils.escapeHtml4((String)html);
    }

    public static String unescapeHtml(String htmlEscaped) {
        return StringEscapeUtils.unescapeHtml4((String)htmlEscaped);
    }

    public static String escapeXml(String xml) {
        return StringEscapeUtils.escapeXml10((String)xml);
    }

    public static String unescapeXml(String xmlEscaped) {
        return StringEscapeUtils.unescapeXml((String)xmlEscaped);
    }

    public static String urlEncode(String part) {
        try {
            return URLEncoder.encode(part, CharsetUtil.DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String urlDecode(String part) {
        try {
            return URLDecoder.decode(part, CharsetUtil.DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.unchecked(e);
        }
    }
}

