/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jeeweb.common.util;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil
extends DateUtils {
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM", "yyyy-MM-dd HH:mm:ss.s", "yyyy-MM-dd HH:mm:ss.ss", "yyyy-MM-dd HH:mm:ss.sss"};

    public static Calendar nowCalendar() {
        return Calendar.getInstance();
    }

    public static Date nowDate() {
        return DateUtil.nowCalendar().getTime();
    }

    public static long nowLong() {
        return DateUtil.nowDate().getTime();
    }

    public static Date getDateBefore(Date date, int day) {
        DateUtil.nowCalendar().setTime(date);
        DateUtil.nowCalendar().set(5, DateUtil.nowCalendar().get(5) - day);
        return DateUtil.nowCalendar().getTime();
    }

    public static Date getDateAfter(Date date, int day) {
        DateUtil.nowCalendar().setTime(date);
        DateUtil.nowCalendar().set(5, DateUtil.nowCalendar().get(5) + day);
        return DateUtil.nowCalendar().getTime();
    }

    public static Date getDateBeforeMinute(Date date, int day) {
        DateUtil.nowCalendar().setTime(date);
        DateUtil.nowCalendar().set(12, DateUtil.nowCalendar().get(12) - day);
        return DateUtil.nowCalendar().getTime();
    }

    public static Date getDateAfterMinute(Date date, int day) {
        DateUtil.nowCalendar().setTime(date);
        DateUtil.nowCalendar().set(12, DateUtil.nowCalendar().get(12) + day);
        return DateUtil.nowCalendar().getTime();
    }

    public static Date parse(String source) {
        if (source == null) {
            return null;
        }
        try {
            return DateUtil.parseDate((String)source, (String[])parsePatterns);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String format(Date date, String ... pattern) {
        if (date == null) {
            return null;
        }
        if (pattern == null || pattern.length == 0) {
            return DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd");
        }
        return DateFormatUtils.format((Date)date, (String)pattern[0]);
    }

    public static String formatUTC(Date date, String pattern) {
        return DateFormatUtils.formatUTC((Date)date, (String)pattern);
    }

    public static String formatDate(Date date, String pattern) {
        return DateUtil.format(date, pattern);
    }

    public static String formatDay() {
        return DateUtil.formatDay(DateUtil.nowDate());
    }

    public static String formatDay(Date date) {
        return DateUtil.format(date, "yyyy-MM-dd");
    }

    public static String formatDayTime() {
        return DateUtil.formatDayTime(DateUtil.nowDate());
    }

    public static String formatDayTime(Date date) {
        return DateUtil.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getYear() {
        return DateUtil.format(DateUtil.nowDate(), "yyyy");
    }

    public static String getMonth() {
        return DateUtil.format(DateUtil.nowDate(), "MM");
    }

    public static String getDay() {
        return DateUtil.format(DateUtil.nowDate(), "dd");
    }

    public static String getHour() {
        return DateUtil.format(DateUtil.nowDate(), "HH");
    }

    public static String getWeek() {
        return DateUtil.format(DateUtil.nowDate(), "E");
    }

    public static long pastDays(Date date) {
        long t = DateUtil.nowLong() - date.getTime();
        return t / 86400000L;
    }

    public static long pastHour(Date date) {
        long t = DateUtil.nowLong() - date.getTime();
        return t / 3600000L;
    }

    public static long pastMinutes(Date date) {
        long t = DateUtil.nowLong() - date.getTime();
        return t / 60000L;
    }
}

