/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jeeweb.common.util;

import cn.com.jeeweb.common.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil
extends FileUtils {
    private static Logger logger = LoggerFactory.getLogger(FileUtil.class);

    public static boolean copyFile(String srcFileName, String descFileName) {
        return FileUtil.copyFileCover(srcFileName, descFileName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFileCover(String srcFileName, String descFileName, boolean coverlay) {
        File srcFile = new File(srcFileName);
        if (!srcFile.exists()) {
            logger.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c\u6e90\u6587\u4ef6 " + srcFileName + " \u4e0d\u5b58\u5728!");
            return false;
        }
        if (!srcFile.isFile()) {
            logger.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c" + srcFileName + " \u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6!");
            return false;
        }
        File descFile = new File(descFileName);
        if (descFile.exists()) {
            if (!coverlay) {
                logger.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c\u76ee\u6807\u6587\u4ef6 " + descFileName + " \u5df2\u5b58\u5728!");
                return false;
            }
            logger.debug("\u76ee\u6807\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u51c6\u5907\u5220\u9664!");
            if (!FileUtil.delFile(descFileName)) {
                logger.debug("\u5220\u9664\u76ee\u6807\u6587\u4ef6 " + descFileName + " \u5931\u8d25!");
                return false;
            }
        } else if (!descFile.getParentFile().exists()) {
            logger.debug("\u76ee\u6807\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u76ee\u5f55!");
            if (!descFile.getParentFile().mkdirs()) {
                logger.debug("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u5931\u8d25!");
                return false;
            }
        }
        int readByte = 0;
        FileInputStream ins = null;
        OutputStream outs = null;
        try {
            ins = new FileInputStream(srcFile);
            outs = new FileOutputStream(descFile);
            byte[] buf = new byte[1024];
            while ((readByte = ((InputStream)ins).read(buf)) != -1) {
                outs.write(buf, 0, readByte);
            }
            logger.debug("\u590d\u5236\u5355\u4e2a\u6587\u4ef6 " + srcFileName + " \u5230" + descFileName + "\u6210\u529f!");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (outs != null) {
                try {
                    outs.close();
                }
                catch (IOException oute) {
                    oute.printStackTrace();
                }
            }
            if (ins != null) {
                try {
                    ((InputStream)ins).close();
                }
                catch (IOException ine) {
                    ine.printStackTrace();
                }
            }
        }
    }

    public static boolean copyDirectory(String srcDirName, String descDirName) {
        return FileUtil.copyDirectoryCover(srcDirName, descDirName, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean copyDirectoryCover(String srcDirName, String descDirName, boolean coverlay) {
        File descDir;
        File srcDir = new File(srcDirName);
        if (!srcDir.exists()) {
            logger.debug("\u590d\u5236\u76ee\u5f55\u5931\u8d25\uff0c\u6e90\u76ee\u5f55 " + srcDirName + " \u4e0d\u5b58\u5728!");
            return false;
        }
        if (!srcDir.isDirectory()) {
            logger.debug("\u590d\u5236\u76ee\u5f55\u5931\u8d25\uff0c" + srcDirName + " \u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55!");
            return false;
        }
        String descDirNames = descDirName;
        if (!descDirNames.endsWith(File.separator)) {
            descDirNames = descDirNames + File.separator;
        }
        if ((descDir = new File(descDirNames)).exists()) {
            if (!coverlay) {
                logger.debug("\u76ee\u6807\u76ee\u5f55\u590d\u5236\u5931\u8d25\uff0c\u76ee\u6807\u76ee\u5f55 " + descDirNames + " \u5df2\u5b58\u5728!");
                return false;
            }
            logger.debug("\u76ee\u6807\u76ee\u5f55\u5df2\u5b58\u5728\uff0c\u51c6\u5907\u5220\u9664!");
            if (!FileUtil.delFile(descDirNames)) {
                logger.debug("\u5220\u9664\u76ee\u5f55 " + descDirNames + " \u5931\u8d25!");
                return false;
            }
        } else {
            logger.debug("\u76ee\u6807\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u51c6\u5907\u521b\u5efa!");
            if (!descDir.mkdirs()) {
                logger.debug("\u521b\u5efa\u76ee\u6807\u76ee\u5f55\u5931\u8d25!");
                return false;
            }
        }
        boolean flag = true;
        File[] files = srcDir.listFiles();
        for (int i = 0; !(i >= files.length || files[i].isFile() && !(flag = FileUtil.copyFile(files[i].getAbsolutePath(), descDirName + files[i].getName())) || files[i].isDirectory() && !(flag = FileUtil.copyDirectory(files[i].getAbsolutePath(), descDirName + files[i].getName()))); ++i) {
        }
        if (!flag) {
            logger.debug("\u590d\u5236\u76ee\u5f55 " + srcDirName + " \u5230 " + descDirName + " \u5931\u8d25!");
            return false;
        }
        logger.debug("\u590d\u5236\u76ee\u5f55 " + srcDirName + " \u5230 " + descDirName + " \u6210\u529f!");
        return true;
    }

    public static boolean delFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            logger.debug(fileName + " \u6587\u4ef6\u4e0d\u5b58\u5728!");
            return true;
        }
        if (file.isFile()) {
            return FileUtil.deleteFile(fileName);
        }
        return FileUtil.deleteDirectory(fileName);
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            if (file.delete()) {
                logger.debug("\u5220\u9664\u6587\u4ef6 " + fileName + " \u6210\u529f!");
                return true;
            }
            logger.debug("\u5220\u9664\u6587\u4ef6 " + fileName + " \u5931\u8d25!");
            return false;
        }
        logger.debug(fileName + " \u6587\u4ef6\u4e0d\u5b58\u5728!");
        return true;
    }

    public static boolean deleteDirectory(String dirName) {
        File dirFile;
        String dirNames = dirName;
        if (!dirNames.endsWith(File.separator)) {
            dirNames = dirNames + File.separator;
        }
        if (!(dirFile = new File(dirNames)).exists() || !dirFile.isDirectory()) {
            logger.debug(dirNames + " \u76ee\u5f55\u4e0d\u5b58\u5728!");
            return true;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = FileUtil.deleteFile(files[i].getAbsolutePath())) : files[i].isDirectory() && !(flag = FileUtil.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            logger.debug("\u5220\u9664\u76ee\u5f55\u5931\u8d25!");
            return false;
        }
        if (dirFile.delete()) {
            logger.debug("\u5220\u9664\u76ee\u5f55 " + dirName + " \u6210\u529f!");
            return true;
        }
        logger.debug("\u5220\u9664\u76ee\u5f55 " + dirName + " \u5931\u8d25!");
        return false;
    }

    public static boolean createFile(String descFileName) {
        File file = new File(descFileName);
        if (file.exists()) {
            logger.debug("\u6587\u4ef6 " + descFileName + " \u5df2\u5b58\u5728!");
            return false;
        }
        if (descFileName.endsWith(File.separator)) {
            logger.debug(descFileName + " \u4e3a\u76ee\u5f55\uff0c\u4e0d\u80fd\u521b\u5efa\u76ee\u5f55!");
            return false;
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            logger.debug("\u521b\u5efa\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u5931\u8d25!");
            return false;
        }
        try {
            if (file.createNewFile()) {
                logger.debug(descFileName + " \u6587\u4ef6\u521b\u5efa\u6210\u529f!");
                return true;
            }
            logger.debug(descFileName + " \u6587\u4ef6\u521b\u5efa\u5931\u8d25!");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug(descFileName + " \u6587\u4ef6\u521b\u5efa\u5931\u8d25!");
            return false;
        }
    }

    public static boolean createDirectory(String descDirName) {
        File descDir;
        String descDirNames = descDirName;
        if (!descDirNames.endsWith(File.separator)) {
            descDirNames = descDirNames + File.separator;
        }
        if ((descDir = new File(descDirNames)).exists()) {
            logger.debug("\u76ee\u5f55 " + descDirNames + " \u5df2\u5b58\u5728!");
            return false;
        }
        if (descDir.mkdirs()) {
            logger.debug("\u76ee\u5f55 " + descDirNames + " \u521b\u5efa\u6210\u529f!");
            return true;
        }
        logger.debug("\u76ee\u5f55 " + descDirNames + " \u521b\u5efa\u5931\u8d25!");
        return false;
    }

    public static void writeToFile(String fileName, String content, boolean append) {
        try {
            FileUtil.write((File)new File(fileName), (CharSequence)content, (String)"utf-8", (boolean)append);
            logger.debug("\u6587\u4ef6 " + fileName + " \u5199\u5165\u6210\u529f!");
        }
        catch (IOException e) {
            logger.debug("\u6587\u4ef6 " + fileName + " \u5199\u5165\u5931\u8d25! " + e.getMessage());
        }
    }

    public static void writeToFile(String fileName, String content, String encoding, boolean append) {
        try {
            FileUtil.write((File)new File(fileName), (CharSequence)content, (String)encoding, (boolean)append);
            logger.debug("\u6587\u4ef6 " + fileName + " \u5199\u5165\u6210\u529f!");
        }
        catch (IOException e) {
            logger.debug("\u6587\u4ef6 " + fileName + " \u5199\u5165\u5931\u8d25! " + e.getMessage());
        }
    }

    public static byte[] getByteByFileName(String filePath) throws IOException {
        int offset;
        File file = new File(filePath);
        long fileSize = file.length();
        if (fileSize > Integer.MAX_VALUE) {
            System.out.println("file too big...");
            return null;
        }
        FileInputStream fi = new FileInputStream(file);
        byte[] buffer = new byte[(int)fileSize];
        int numRead = 0;
        for (offset = 0; offset < buffer.length && (numRead = fi.read(buffer, offset, buffer.length - offset)) >= 0; offset += numRead) {
        }
        if (offset != buffer.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        fi.close();
        return buffer;
    }

    public static String getFileSuffix(String fileName) {
        String suffix = "";
        if (StringUtil.isBlank((CharSequence)fileName)) {
            return suffix;
        }
        if (fileName.contains(".")) {
            suffix = fileName.substring(fileName.lastIndexOf("."));
        }
        return suffix.toLowerCase();
    }

    public static String getFileNameNoSuffix(String fileName) {
        if (StringUtil.isBlank((CharSequence)fileName)) {
            return "";
        }
        if (fileName.contains(".")) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }
}

