/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jeeweb.common.util;

import cn.com.jeeweb.common.util.AesUtil;
import cn.com.jeeweb.common.util.CodecUtil;
import cn.com.jeeweb.common.util.Digests;
import cn.com.jeeweb.common.util.StringUtil;

public class PasswordUtil {
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_INTERATIONS = 1024;
    public static final int SALT_SIZE = 8;

    public static String entryptPassword(String plainPassword) {
        String plain = CodecUtil.unescapeHtml(plainPassword);
        byte[] salt = Digests.generateSalt(8);
        byte[] hashPassword = Digests.sha1(plain.getBytes(), salt, 1024);
        return CodecUtil.encodeHex(salt) + CodecUtil.encodeHex(hashPassword);
    }

    public static boolean validatePassword(String plainPassword, String password) {
        String plain = CodecUtil.unescapeHtml(plainPassword);
        byte[] salt = CodecUtil.decodeHex(password.substring(0, 16));
        byte[] hashPassword = Digests.sha1(plain.getBytes(), salt, 1024);
        return password.equals(CodecUtil.encodeHex(salt) + CodecUtil.encodeHex(hashPassword));
    }

    public static String enPwd(String pwd) {
        String s;
        try {
            String keyStr = StringUtil.getRandomCode(16);
            String encryptStr = AesUtil.encryptByECB(CodecUtil.encodeBase64(keyStr), pwd);
            s = keyStr + encryptStr;
        }
        catch (Exception e) {
            s = "";
        }
        return s;
    }

    public static String dePwd(String pwd) {
        try {
            if (StringUtil.isBlank((CharSequence)pwd)) {
                return "";
            }
            String keyStr = pwd.substring(0, 16);
            String encryptStr = pwd.substring(16);
            String decryptStr = AesUtil.decryptByECB(CodecUtil.encodeBase64(keyStr), encryptStr);
            return decryptStr;
        }
        catch (Exception e) {
            String s = "";
            return s;
        }
    }
}

